package com.aote.util;

import com.af.expression.Delegate;
import com.af.expression.Program;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ExpressionHelper {

	/**
	 * 带参运行表达式
	 * @param source: 表达式源码
	 * @param params: 表达式参数
	 */
	public static Object run(String source, Map<String, Object> params) {
		// 如果有save声明，设置JSON对象支持属性不存在条件
		List<String> enveronments = new ArrayList<>();
		source = getEnveronments(source, enveronments);

		Program prog = new Program(source);
		// 解析
		Delegate d = prog.parse();
		if (enveronments.contains("save")) {
			d.CanJsonPropertyChoise = true;
		}
		return d.invoke(params);
	}

	// 从source中获取环境配置，返回读掉环境配置后的源程序
	private static String getEnveronments(String source, List<String> result) {
		// 环境配置以#开始，每种配置用“,”隔开
		if (!source.startsWith("#")) {
			return source;
		}

		// 读取一行数据, 包括所有配置
		int pos = source.indexOf("\n");
		String config = source.substring(1, pos);
		Collections.addAll(result, config.split(","));

		source = source.substring(pos + 1);
		return source;
	}
}
