/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.exception.ExceptionLogManage;
import com.aote.sql.SqlServer;
import com.aote.util.ExceptionHelper;
import com.aote.util.JsonHelper;
import com.aote.util.ParamFilter;
import com.aote.util.ResourceHelper;
import com.aote.util.Util;
import com.aote.util.other.AESUtil;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Path(value="sql")
@Component
@Transactional
public class SqlService {
    static Logger log = Logger.getLogger(SqlService.class);
    @Autowired
    private SqlServer sqlServer;
    @Autowired
    private ExceptionLogManage exceptionLogManage;

    @GET
    @Path(value="/clear")
    public String clearSQLCache() {
        ResourceHelper.clearLogicCache();
        ResourceHelper.clearSqlCache();
        ResourceHelper.clearPathCache();
        return "ok";
    }

    @POST
    @Path(value="{name}/n")
    public String txgetTotalCnt(@PathParam(value="name") String name, String str) throws Exception {
        try {
            return this.sqlEncrypt(name, str, 1, new int[0]);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            this.exceptionLogManage.writeError(ex, name, "/rs/sql/" + name + "/n");
            throw ex;
        }
    }

    @POST
    @Path(value="{name}")
    public String txExecute(@PathParam(value="name") String name, @QueryParam(value="pageNo") int pageNo, @QueryParam(value="pageSize") int pageSize, String str) throws Exception {
        try {
            return this.sqlEncrypt(name, str, 2, pageNo, pageSize);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            this.exceptionLogManage.writeError(ex, name, "/rs/sql/" + name);
            throw ex;
        }
    }

    @POST
    @Path(value="hql/{name}/n")
    public String txHqlgetTotalCnt(@PathParam(value="name") String name, String str) throws Exception {
        try {
            return this.sqlEncrypt(name, str, 3, new int[0]);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            this.exceptionLogManage.writeError(ex, name, "/rs/sql/hql/" + name + "/n");
            throw ex;
        }
    }

    @POST
    @Path(value="hql/{name}")
    public String txHqlExecute(@PathParam(value="name") String name, @QueryParam(value="pageNo") int pageNo, @QueryParam(value="pageSize") int pageSize, String str) throws Exception {
        try {
            return this.sqlEncrypt(name, str, 4, pageNo, pageSize);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            this.exceptionLogManage.writeError(ex, name, "/rs/sql/hql/" + name);
            throw ex;
        }
    }

    @POST
    @Path(value="hql/{name}/all")
    public String txHqlExecuteAll(@PathParam(value="name") String name, @QueryParam(value="pageNo") int pageNo, @QueryParam(value="pageSize") int pageSize, String str) throws Exception {
        try {
            return this.sqlEncrypt(name, str, 5, pageNo, pageSize);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            this.exceptionLogManage.writeError(ex, name, "/rs/sql/hql/" + name + "/all");
            throw ex;
        }
    }

    private String sqlEncrypt(String sqlName, String param, int method, int ... value) throws Exception {
        JSONObject paramJson = new JSONObject(param);
        JSONObject configJson = JsonHelper.getConfig();
        int checkEncry = Util.checkEncry(paramJson, configJson);
        String encryKey = null;
        if (checkEncry == 1) {
            String type = paramJson.getString("aoteEncrypt");
            if ("AES".equals(type)) {
                assert (configJson != null);
                encryKey = configJson.getString("encryKey");
                assert (encryKey != null);
                String data = paramJson.getString("data");
                param = AESUtil.decrypt(data, encryKey);
            } else {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u89e3\u5bc6\u7c7b\u578b\uff01" + type);
            }
        }
        boolean sqlInject = false;
        if (configJson != null && configJson.has("sqlInject")) {
            sqlInject = configJson.getBoolean("sqlInject");
        }
        if (sqlInject) {
            ParamFilter.checkSqlJsonStr(param);
        }
        String result = method == 1 ? this.sqlServer.queryTotal(sqlName, param).toString() : (method == 2 ? this.sqlServer.query(sqlName, value[0], value[1], param).toString() : (method == 3 ? this.sqlServer.queryHqlTotal(sqlName, param).toString() : (method == 4 ? this.sqlServer.hqlQuery(sqlName, value[0], value[1], param).toString() : this.sqlServer.hqlQueryAll(sqlName, value[0], value[1], param).toString())));
        if (checkEncry == 1) {
            result = AESUtil.encrypt(result, encryKey);
        }
        return result;
    }
}

