/*
 * Decompiled with CFR 0.152.
 */
package com.aote.exception;

import com.aote.entity.EntityServer;
import com.aote.sql.SqlServer;
import com.aote.util.ExceptionHelper;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
public class ExceptionLogManage {
    private static Logger LOGGER = Logger.getLogger(ExceptionLogManage.class);
    @Autowired
    private EntityServer entityServer;
    @Autowired
    private SqlServer sqlServer;

    public void writeError(Exception e, String path) {
        JSONObject params;
        JSONArray logs;
        String title;
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String serviceName = request.getContextPath();
        String errorInfo = ExceptionHelper.stackToString(e);
        int causedByIndex = (errorInfo = errorInfo.replace("'", "''")).lastIndexOf("Caused by");
        if (causedByIndex != -1) {
            title = errorInfo.substring(causedByIndex);
            title = title.substring(0, title.indexOf("at "));
        } else {
            title = e.getMessage();
        }
        try {
            logs = path == null ? this.sqlServer.querySQL("SELECT id,f_times FROM t_log WHERE f_service = '" + serviceName + "' and f_error_title = '" + title + "'") : this.sqlServer.querySQL("SELECT id,f_times FROM t_log WHERE f_service = '" + serviceName + "' and f_src = '" + path + "' and f_error_title = '" + title + "'");
        }
        catch (Exception exception) {
            LOGGER.error((Object)exception);
            logs = new JSONArray();
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = format.format(new Date());
        if (logs.length() > 0) {
            params = logs.getJSONObject(0);
            int times = params.getInt("f_times");
            int id = params.getInt("id");
            params.put("f_times", times + 1);
            params.put("f_last_update_time", (Object)date);
            params.put("id", id);
        } else {
            errorInfo = ExceptionLogManage.getLogicErrorInfo(errorInfo);
            params = new JSONObject();
            params.put("f_service", (Object)serviceName);
            params.put("f_src", (Object)path);
            params.put("f_log_type", (Object)"\u5f02\u5e38");
            params.put("f_error_title", (Object)title);
            params.put("f_error_msg", (Object)errorInfo);
            params.put("f_first_update_time", (Object)date);
            params.put("f_last_update_time", (Object)date);
            params.put("f_times", 1);
        }
        try {
            this.entityServer.partialSave("t_log", params);
        }
        catch (Exception exception) {
            LOGGER.error((Object)exception);
        }
    }

    private static String getLogicErrorInfo(String errorInfo) {
        StringBuilder builder = new StringBuilder("==================\n");
        ExceptionLogManage.appendLogicErrorInfo(builder, errorInfo);
        return builder.toString();
    }

    private static void appendLogicErrorInfo(StringBuilder result, String errorInfo) {
        int ignoreIndex = errorInfo.indexOf("com.af.expression.ExpressionException: ");
        if (ignoreIndex != -1) {
            int ignoreIndexEnd = (errorInfo = errorInfo.substring(ignoreIndex + 39)).indexOf("at ");
            if (ignoreIndexEnd != -1) {
                result.append(errorInfo, 0, ignoreIndexEnd).append("\n==================\n");
                errorInfo = errorInfo.substring(ignoreIndexEnd + 3);
                ExceptionLogManage.appendLogicErrorInfo(result, errorInfo);
            }
        } else {
            ignoreIndex = errorInfo.lastIndexOf("Caused by:");
            if (ignoreIndex != -1) {
                result.append(errorInfo.substring(ignoreIndex));
            }
        }
    }
}

