/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.entity.EntityServer;
import com.aote.exception.ExceptionLogManage;
import com.aote.util.ExceptionHelper;
import com.aote.util.JsonHelper;
import com.aote.util.ParamFilter;
import com.aote.util.Util;
import com.aote.util.other.AESUtil;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Path(value="entity")
@Singleton
@Component
@Transactional
public class EntityService {
    static Logger log = Logger.getLogger(EntityService.class);
    @Autowired
    private EntityServer entityServer;
    @Autowired
    private ExceptionLogManage exceptionLogManage;

    @POST
    @Path(value="{entity}")
    public String xtSave(@PathParam(value="entity") String entityName, String values) throws Exception {
        try {
            return this.entityEncrypt(entityName, values);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            this.exceptionLogManage.writeError(ex, entityName);
            throw ex;
        }
    }

    @DELETE
    @Path(value="{entity}/{id}")
    public String txDelete(@PathParam(value="entity") String entityName, @PathParam(value="id") String id) throws Exception {
        try {
            return this.entityServer.delete(entityName, id);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            this.exceptionLogManage.writeError(ex, entityName);
            throw ex;
        }
    }

    private String entityEncrypt(String entityName, String param) throws Exception {
        JSONObject paramJson = new JSONObject(param);
        JSONObject configJson = JsonHelper.getConfig();
        Util.checkEncry(paramJson, configJson);
        if (!paramJson.has("aoteEncrypt")) {
            paramJson.put("aoteEncrypt", (Object)"default");
        }
        boolean sqlInject = false;
        if (configJson.has("sqlInject")) {
            sqlInject = configJson.getBoolean("sqlInject");
        }
        switch (paramJson.getString("aoteEncrypt")) {
            case "AES": {
                String data = paramJson.getString("data");
                String encryKey = configJson.getString("encryKey");
                String decryData = AESUtil.decrypt(data, encryKey);
                if (sqlInject) {
                    ParamFilter.checkSqlJsonStr(decryData);
                }
                return AESUtil.encrypt(this.entityServer.partialSave(entityName, decryData), encryKey);
            }
        }
        if (sqlInject) {
            ParamFilter.checkSqlJsonStr(param);
        }
        log.debug((Object)("entityName:" + entityName + ", params:" + param));
        return this.entityServer.partialSave(entityName, param);
    }

    @PostConstruct
    public void init() {
        this.entityServer.loadMetaData();
    }
}

