package com.aote.queryparams;

import com.aote.exception.FileNotFoundException;
import com.aote.rs.mapper.WebException;
import com.aote.util.ResourceHelper;
import com.aote.util.ResourceType;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.Iterator;

@Component
public class QueryParamsServer {
    /**
     * 生成前台查询条件
     * @param params 前端传入的表单参数
     * @return 文件内容
     */
    public static String getValue(String queryParamsName, JSONObject params) throws Exception{
        String path = QueryParamsMapper.getQueryParams(queryParamsName);
        if (path == null) {
            throw new RuntimeException("查询参数未找到: " + queryParamsName);
        }
        JSONObject realQueryParamsMap;
        try {
            realQueryParamsMap = (JSONObject) ResourceHelper.getString(ResourceType.QUERY_PARAMS,queryParamsName,path);
        } catch (FileNotFoundException e) {
            throw new RuntimeException(path + ".文件无配置");
        } catch (IOException io) {
            throw new RuntimeException(io);
        }
        // 循环前台传过来的条件参数
        Iterator<String> iterator = params.keys();
        // 查询条件
        StringBuilder condition = new StringBuilder(" 1=1");
        while(iterator.hasNext()) {
            String key = iterator.next();
            String value = String.valueOf(params.get(key));
            //前台的条件参数有值
            if (value.length() != 0 && (!value.equals("全部"))) {
                if (realQueryParamsMap.has(key)) {
                    JSONObject queryParams = realQueryParamsMap.getJSONObject(key);
                    //获取查询类型
                    QueryTypeEnum queryType = QueryTypeEnum.toType(queryParams.getString("queryType"));
                    //获取实际的查询字段
                    String realKey = queryParams.getString("key");
                    switch (queryType) {
                        case EQUALS:
                        case NO_EQUALS:
                        case LESS_THAN:
                        case LESS_THAN_EQUALS:
                        case GREATER_THAN:
                        case GREATER_THAN_EQUALS:
                            condition.append(" AND ").append(realKey).append(" ").append(queryType.getValue()).append("'").append(value).append("'");
                            break;
                        case INNER_LIKE:
                            condition.append(" AND ").append(realKey).append(" LIKE '%").append(value).append("%'");
                            break;
                        case LEFT_LIKE:
                            condition.append(" AND ").append(realKey).append(" LIKE '%").append(value).append("'");
                            break;
                        case RIGHT_LIKE:
                            condition.append(" AND ").append(realKey).append(" LIKE '").append(value).append("%'");
                            break;
                        case IN:
                            condition.append(" AND ").append(realKey).append(" IN (").append(value).append(")");
                            break;
                        case NOT_IN:
                            condition.append(" AND ").append(realKey).append(" NOT IN (").append(value).append(")");
                            break;
                        case BETWEEN:
                            //将参数按照,分割
                            String[] values = StringUtils.split(value,",");
                            condition.append(" AND ").append(realKey).append(" BETWEEN '").append(values[0]).append(" AND ").append(values[1]);
                            break;
                    }
                } else {
                    throw new WebException( 500,"文件'"+path+"'缺少字段'"+key+"'");
                }
            }
        }
        return condition.toString();
    }
}
