package com.aote.exception;

import com.aote.entity.EntityServer;
import com.aote.util.ExceptionHelper;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transactional;

/**
 * 异常日志记录管理
 */
@Component
@Transactional
public class ExceptionLogManage {
    private static Logger LOGGER = Logger.getLogger(ExceptionLogManage.class);

    @Autowired
    private EntityServer entityServer;

    public void writeError(Exception e, String path) {
        HttpServletRequest request = ((ServletRequestAttributes)
                RequestContextHolder.getRequestAttributes()).getRequest();
        String serviceName = request.getContextPath();
        String errorInfo = ExceptionHelper.stackToString(e);
        JSONObject params = new JSONObject();
        params.put("f_service",serviceName);
        params.put("f_src",path);
        params.put("f_log_type","异常");
        params.put("f_error_msg",errorInfo);
        try {
            entityServer.partialSave("t_log",params);
        } catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}
