/*
 * Decompiled with CFR 0.152.
 */
package com.aote.file;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aote.config.SystemConfig;
import com.aote.entity.EntityServer;
import com.aote.rs.enums.ResUploadModeEnum;
import com.aote.sql.SqlServer;
import com.aote.util.other.Base64Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Transactional
public class FileServer {
    private static final Logger LOGGER = Logger.getLogger(FileServer.class);
    @Autowired
    private SqlServer sqlServer;
    @Autowired
    private EntityServer entityServer;

    public FileUploadResult uploadFile(InputStream fileInputStream, String resUploadMode, int f_stock_id, String filename, BigDecimal filesize, String f_operator, String pathKey, FormDataContentDisposition disposition, String formType) throws Exception {
        FileUploadResult result;
        JSONArray extraPathKeys;
        ResUploadModeEnum resUploadTypeEnum = ResUploadModeEnum.toType(resUploadMode);
        if (resUploadTypeEnum == null) {
            return new FileUploadResult(false, "\u4e0d\u652f\u6301\u8be5\u8d44\u6e90\u4e0a\u4f20\u7c7b\u578b\uff1a" + resUploadMode);
        }
        String sql = "select * from t_files_manager where id = " + f_stock_id;
        JSONArray stock = new JSONArray(this.sqlServer.querySQL(sql).toList());
        String fileRootPath = stock.getJSONObject(0).getString("f_root_path") + stock.getJSONObject(0).getString("f_alias");
        String extraPathKey = null;
        if (pathKey != null && (extraPathKeys = new JSONArray(JSONArray.parseArray((String)stock.getJSONObject(0).getString("f_lower_path_json")).stream().filter(item -> Objects.equals(((JSONObject)item).getString("label"), pathKey)).collect(Collectors.toList()))).size() > 0) {
            extraPathKey = extraPathKeys.getJSONObject(0).getString("value");
        }
        switch (resUploadTypeEnum) {
            default: {
                String fileName = this.uploadFileToServer(fileInputStream, f_stock_id, fileRootPath, extraPathKey, filename, filesize, f_operator, formType);
                result = new FileUploadResult(true, fileName);
                break;
            }
            case BASE64: {
                String base64 = this.uploadFileToBase64(fileInputStream);
                result = new FileUploadResult(true, base64);
                break;
            }
            case OSS: {
                String ossResult = this.uploadFileToOSS(fileInputStream, disposition);
                result = new FileUploadResult(true, ossResult);
            }
        }
        return result;
    }

    public String uploadFileToServer(InputStream fileInputStream, FormDataContentDisposition disposition, String extraPathKey) throws IOException {
        String fileSuffix = disposition.getFileName().substring(disposition.getFileName().lastIndexOf(46) + 1);
        String path = SystemConfig.Resources.getFileRootPath();
        if (extraPathKey != null) {
            path = path + SystemConfig.Resources.getExtraPath(extraPathKey);
        }
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String formatDate = sdf.format(date);
        path = path + "\\" + formatDate;
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String fileName = uuid + "." + fileSuffix;
        path = path + "\\" + fileName;
        File fileDir = new File(path);
        FileUtils.copyToFile((InputStream)fileInputStream, (File)fileDir);
        return fileName;
    }

    public String uploadFileToServer(InputStream fileInputStream, int f_stock_id, String path, String extraPathKey, String filename, BigDecimal filesize, String f_operator, String formType) throws Exception {
        String fileSuffix = filename.substring(filename.lastIndexOf(46) + 1);
        if (extraPathKey != null) {
            path = path + File.separator + extraPathKey;
        }
        String formatDate = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String uuid = UUID.randomUUID().toString().replace("-", "");
        path = path + File.separator + formatDate;
        path = path + File.separator + uuid + "." + fileSuffix;
        System.out.println(path);
        File fileDir = new File(path);
        org.json.JSONObject files_entity = new org.json.JSONObject();
        String f_downloadpath = path.replace("\\", "/").substring(17);
        files_entity.put("f_filename", (Object)filename);
        files_entity.put("f_stock_id", f_stock_id);
        files_entity.put("f_filetype", (Object)fileSuffix);
        files_entity.put("f_downloadpath", (Object)f_downloadpath);
        files_entity.put("f_realpath", (Object)path);
        files_entity.put("f_file_size", (Object)filesize);
        files_entity.put("f_operator", (Object)f_operator);
        files_entity.put("f_form_type", (Object)formType);
        FileUtils.copyToFile((InputStream)fileInputStream, (File)fileDir);
        files_entity.put("id", (Object)JSONObject.parseObject((String)this.entityServer.partialSave("t_files", files_entity)).getString("id"));
        return files_entity.toString();
    }

    public String uploadFileToBase64(InputStream fileInputStream) throws IOException {
        return Base64Utils.encode(IOUtils.toByteArray((InputStream)fileInputStream));
    }

    public String uploadFileToOSS(InputStream fileInputStream, FormDataContentDisposition disposition) {
        throw new RuntimeException("\u6682\u672a\u5b9e\u73b0OSS\u5bf9\u8c61\u5b58\u50a8\u6a21\u5f0f");
    }

    public static class FileUploadResult {
        private final Boolean isSuccess;
        private final String data;

        private FileUploadResult(boolean isSuccess, String data) {
            this.isSuccess = isSuccess;
            this.data = data;
        }

        public Boolean getSuccess() {
            return this.isSuccess;
        }

        public String getData() {
            return this.data;
        }
    }
}

