/*
 * Decompiled with CFR 0.152.
 */
package com.aote.exception;

import com.aote.config.SystemConfig;
import com.aote.entity.EntityServer;
import com.aote.sql.SqlServer;
import com.aote.util.ExceptionHelper;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
public class ExceptionLogManage {
    private static final Logger LOGGER = Logger.getLogger(ExceptionLogManage.class);
    @Autowired
    private EntityServer entityServer;
    @Autowired
    private SqlServer sqlServer;

    public void writeError(Exception e, String path, String webUrl, String values) {
        JSONObject params;
        JSONArray logs;
        String title;
        if (!SystemConfig.PersistenceLog.getEnabled().booleanValue()) {
            return;
        }
        String serviceName = SystemConfig.System.getWebAppName();
        String errorInfo = ExceptionHelper.stackToString(e);
        int causedByIndex = (errorInfo = errorInfo.replace("'", "''")).lastIndexOf("Caused by");
        if (causedByIndex != -1) {
            title = errorInfo.substring(causedByIndex);
            title = title.substring(0, title.indexOf("at "));
        } else {
            title = e.getClass() + ": " + e.getMessage();
            title = title.replace("'", "''");
        }
        try {
            logs = path == null ? this.sqlServer.querySQL("SELECT id,f_times FROM t_log WHERE f_service = '" + serviceName + "' and f_error_title = '" + title + "' and f_status != '\u5df2\u5b8c\u6210'", true) : this.sqlServer.querySQL("SELECT id,f_times FROM t_log WHERE f_service = '" + serviceName + "' and f_src = '" + path + "' and f_error_title = '" + title + "' and f_status != '\u5df2\u5b8c\u6210'", true);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"\u5b58\u50a8\u5f02\u5e38\u65e5\u5fd7\u62a5\u9519\uff1a", (Throwable)exception);
            logs = new JSONArray();
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = format.format(new Date());
        if (logs.length() > 0) {
            params = logs.getJSONObject(0);
            int times = params.getInt("f_times");
            int id = params.getInt("id");
            params.put("f_times", times + 1);
            params.put("f_last_update_time", (Object)date);
            params.put("id", id);
        } else {
            int type = webUrl.contains("rs/sql") ? 2 : 1;
            String errorInfoData = ExceptionLogManage.getErrorInfo(errorInfo, type);
            int maxLength = EntityServer.findDialect().equals("Oracle") ? 4000 : (EntityServer.findDialect().equals("SqlServer") ? 8000 : 99999);
            while (errorInfoData.getBytes().length > maxLength) {
                int length = errorInfoData.length();
                errorInfoData = errorInfoData.substring(0, length - 60);
                errorInfoData = errorInfoData + "\n\u8d85\u8fc7\u5bb9\u91cf,\u7701\u7565\u540e\u7eed\u5b57\u7b26...";
            }
            params = new JSONObject();
            params.put("f_service", (Object)serviceName);
            params.put("f_web_url", (Object)webUrl);
            params.put("f_params", (Object)values);
            params.put("f_src", (Object)path);
            params.put("f_log_type", (Object)"\u5f02\u5e38");
            params.put("f_error_title", (Object)title);
            params.put("f_error_msg", (Object)errorInfoData);
            params.put("f_first_update_time", (Object)date);
            params.put("f_last_update_time", (Object)date);
            params.put("f_status", (Object)"\u5f85\u529e\u7684");
            params.put("f_times", 1);
        }
        try {
            this.entityServer.partialSave("t_log", params, true);
        }
        catch (Exception exception) {
            LOGGER.error((Object)params);
            LOGGER.error((Object)"\u5b58\u50a8\u5f02\u5e38\u65e5\u5fd7\u62a5\u9519\uff1a", (Throwable)exception);
        }
    }

    public static String getErrorInfo(String errorInfo, int type) {
        String result;
        try {
            String defaultHeader = "ERROR!======\n";
            String defaultHeaderEnd = "\nERROR_END!=====";
            StringBuilder builder = new StringBuilder(defaultHeader);
            if (type == 1) {
                ExceptionLogManage.appendLogicErrorInfo(builder, errorInfo);
            } else {
                ExceptionLogManage.appendSqlErrorInfo(builder, errorInfo);
            }
            builder.append(defaultHeaderEnd);
            result = builder.toString();
            if (result.equals(defaultHeader + defaultHeaderEnd)) {
                result = errorInfo;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"***\u62a5\u9519\u5806\u6808\u622a\u53d6\u62a5\u9519***", (Throwable)e);
            result = errorInfo;
        }
        return result;
    }

    private static void appendSqlErrorInfo(StringBuilder result, String errorInfo) {
        int endIndex;
        String keySentences = "org.hibernate.exception.SQLGrammarException: sql:\n";
        int ignoreIndex = errorInfo.indexOf(keySentences);
        if (ignoreIndex != -1 && (endIndex = errorInfo.indexOf("could not extract ResultSet")) != -1) {
            String head = errorInfo.substring(ignoreIndex + keySentences.length(), endIndex);
            result.append(head).append("=====\n");
        }
        if ((ignoreIndex = errorInfo.lastIndexOf("Caused by:")) != -1) {
            result.append(errorInfo.substring(ignoreIndex));
        }
    }

    private static void appendLogicErrorInfo(StringBuilder result, String errorInfo) {
        String keySentences = "com.af.expression.ExpressionException: ";
        int ignoreIndex = errorInfo.indexOf(keySentences);
        if (ignoreIndex != -1) {
            int ignoreIndexEnd = (errorInfo = errorInfo.substring(ignoreIndex + keySentences.length())).indexOf("at ");
            if (ignoreIndexEnd != -1) {
                result.append(errorInfo, 0, ignoreIndexEnd).append("\n=====\n");
                errorInfo = errorInfo.substring(ignoreIndexEnd + 3);
                ExceptionLogManage.appendLogicErrorInfo(result, errorInfo);
            }
        } else {
            ignoreIndex = errorInfo.lastIndexOf("Caused by:");
            if (ignoreIndex != -1) {
                result.append(errorInfo.substring(ignoreIndex));
            }
        }
    }
}

