package com.aote.util;

import org.json.JSONObject;

import com.aote.rs.mapper.WebException;

/**
 * 为业务逻辑提供各种辅助功能
 * @author he
 */
public class Util {
	/**
	 * 抛异常
	 */
	public void error(JSONObject param) {
		int status = Integer.parseInt(param.get("status").toString());
		String msg = (String)param.get("msg");
		throw new WebException(status, msg);
	}

	/**
	 * 加密验证
	 * @param params 请求数据
	 * @param config 配置数据
	 * @return	验证结果 0：无需加密，1：需要加密
	 */
	public static int checkEncry(JSONObject params, JSONObject config){
		// 前台数据加密，但是后台没有config.json获取不到密钥，抛出异常
		if (config == null){
			if(params.has("aoteEncrypt")){
				throw new RuntimeException("前台数据已经加密，后台无法读取config.json文件！");
			} else {
				return 0;
			}
		} else {
			//需要加密
			if(config.has("isEncrypt") && config.getBoolean("isEncrypt")){
				if (params.has("aoteEncrypt")) {
					if (!config.has("encryKey")) {
						throw new RuntimeException("前台数据已经加密，后台从config.json读取密钥失败！");
					} else {
						return 1;
					}
				} else {
					throw new RuntimeException("数据要求强制加密！");
				}
			} else {
				return 0;
			}
		}
	}
}
