package com.aote.rs;

import com.aote.file.FileServer;
import org.apache.log4j.Logger;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import java.io.InputStream;
import java.math.BigDecimal;

/**
 * 文件控制器
 * @author Mr.river
 */
@Component
@Path("resource")
public class FileService {
    private static final Logger LOGGER = Logger.getLogger(FileService.class);

    @Autowired
    private FileServer fileServer;

//    /**
//     * 文件上传
//     * @param fileInputStream 文件流
//     * @param disposition 描述
//     * @param resUploadMode 资源上传模式
//     * @return 响应
//     */
//    @POST
//    @Path("/upload/{resUploadMode}")
//    @Consumes(MediaType.MULTIPART_FORM_DATA)
//    public Response upload(@FormDataParam("avatar") InputStream fileInputStream,
//                                @FormDataParam("avatar") FormDataContentDisposition disposition,
//                                @PathParam("resUploadMode") String resUploadMode) throws IOException {
//        FileServer.FileUploadResult result = fileServer.uploadFile(fileInputStream, disposition, resUploadMode, null);
//        if(result.getSuccess()){
//            return Response.ok().entity(result).build();
//        } else {
//            return Response.status(Response.Status.BAD_REQUEST).entity(result.getData()).build();
//        }
//    }

//    /**
//     * 文件上传（指定路径）
//     * @param fileInputStream 文件流
//     * @param disposition 描述
//     * @param resUploadMode 资源上传模式
//     * @return 响应
//     */
//    @POST
//    @Path("/upload/{resUploadMode}/{pathKey}")
//    @Consumes(MediaType.MULTIPART_FORM_DATA)
//    public Response uploadByPathKey(@FormDataParam("avatar") InputStream fileInputStream,
//                                         @FormDataParam("avatar") FormDataContentDisposition disposition,
//                                         @PathParam("resUploadMode") String resUploadMode,
//                                         @PathParam("pathKey") String pathKey) throws IOException {
//        FileServer.FileUploadResult result = fileServer.uploadFile(fileInputStream, disposition, resUploadMode, pathKey);
//        if(result.getSuccess()){
//            return Response.ok().entity(result).build();
//        } else {
//            return Response.status(Response.Status.BAD_REQUEST).entity(result.getData()).build();
//        }
//    }


    @POST
    @Path("/upload")
    @Consumes(MediaType.MULTIPART_FORM_DATA)
    public Response uploadByPathKey(
            @FormDataParam("avatar") InputStream fileInputStream,
            @FormDataParam("resUploadMode") String resUploadMode,
            @FormDataParam("avatar") FormDataContentDisposition disposition,
            @FormDataParam("resUploadStock") int resUploadStock,
            @FormDataParam("filesize") BigDecimal filesize,
            @FormDataParam("filename") String filename,
            @FormDataParam("f_operator") String f_operator,
            @FormDataParam("pathKey") String pathKey,
            @FormDataParam("formType") String formType
            )
            throws Exception {
        FileServer.FileUploadResult result = fileServer.uploadFile(fileInputStream, resUploadMode, resUploadStock, filename, filesize, f_operator, pathKey, disposition, formType);
        if (result.getSuccess()) {
            return Response.ok().entity(result).build();
        } else {
            return Response.status(Response.Status.BAD_REQUEST).entity(result.getData()).build();
        }
    }
}
