package com.aote.queryparams;

import com.aote.redis.RedisUtil;
import com.aote.rs.SqlService;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

/**
 * 查询参数映射器
 *
 * @author Mr.river
 */
@Component
public class QueryParamsMapper {

	private static final Logger LOGGER = Logger.getLogger(QueryParamsMapper.class);

	public static final String QUERY_PARAMS_IS_LOADED_KEY = "QUERY_PARAMS_IS_LOADED";
	public static final String NO_LOAD_FLAG = "0";
	public static final String LOADED_FLOG = "1";
	public static final String QUERY_PARAMS_PREFIX = "QP_";
	private static final String QUERY_SQL = "SELECT * FROM T_QUERY_PARAMS";

	@Autowired
	private SqlService sqlService;

	@PostConstruct
	public void load() {
		RedisUtil redisUtil = RedisUtil.getInstance();
		if(redisUtil != null){
			redisUtil.lock(QUERY_PARAMS_IS_LOADED_KEY, ()->{
				Object isLoaded = redisUtil.get(QUERY_PARAMS_IS_LOADED_KEY);
				if(isLoaded == null || NO_LOAD_FLAG.equals(isLoaded)){
					JSONArray result = null;
					try {
						result = new JSONArray(sqlService.txQuery(QUERY_SQL));
					} catch (Exception e) {
						LOGGER.warn("查询配置表(t_query_params)查询失败，不再加载查询配置");
					}
					if(result != null) {
						for (Object o : result) {
							JSONObject item = (JSONObject) o;
							if(item.has("f_content")){
								JSONObject compileSource = QueryParamsServer.getQueryParamsInfo(item.getString("f_content"));
								redisUtil.set(QUERY_PARAMS_PREFIX + item.getString("f_name"), compileSource);
							}
						}
						//修改加载标识
						redisUtil.set(QUERY_PARAMS_IS_LOADED_KEY, LOADED_FLOG);
						LOGGER.debug("查询配置预加载完成");
					}
				} else {
					LOGGER.debug("跳过加载查询配置表");
				}
			});
		}
	}
}
