/*
 * Decompiled with CFR 0.152.
 */
package com.aote.sql;

import com.aote.ThreadResource;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class SqlMapper {
    static Logger log = Logger.getLogger(SqlMapper.class);
    private static Map<String, Map<String, String>> map;

    public static synchronized String getSql(String alias) {
        if (map == null) {
            SqlMapper.loadMap();
        }
        if (map.containsKey(alias)) {
            String result = SqlMapper.getSqlByUser(alias);
            if (result != null) {
                return result;
            }
            return map.get(alias).get("path");
        }
        return null;
    }

    public static synchronized Map<String, Map<String, String>> getMap() {
        if (map == null) {
            SqlMapper.loadMap();
        }
        return map;
    }

    public static String getSqlByUser(String alias) {
        String dir = ThreadResource.ComponentDir.get();
        if (dir == null) {
            return null;
        }
        String path = "/" + dir + "/sqls/" + alias + ".sql";
        if (SqlMapper.class.getResource(path) != null) {
            return path;
        }
        return null;
    }

    private static void loadMap() {
        map = new HashMap<String, Map<String, String>>();
        SAXReader reader = new SAXReader();
        InputStream module = SqlMapper.class.getClassLoader().getResourceAsStream("module.xml");
        try {
            InputStream input;
            if (module != null) {
                SqlMapper.parseModule(module);
            }
            if ((input = SqlMapper.class.getClassLoader().getResourceAsStream("sql.xml")) != null) {
                Document document = reader.read(input);
                Element root = document.getRootElement();
                Iterator it = root.elementIterator("sql");
                while (it.hasNext()) {
                    Element elm = (Element)it.next();
                    HashMap<String, String> logic = new HashMap<String, String>();
                    String alias = elm.attribute("alias").getValue();
                    logic.put("alias", alias);
                    String path = elm.attribute("path").getValue();
                    logic.put("path", "sqls/" + path);
                    String mobile = elm.attributeValue("mobile");
                    logic.put("mobile", mobile);
                    map.put(alias, logic);
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void parseModule(InputStream input) throws Exception {
        SAXReader reader = new SAXReader();
        Document document = reader.read(input);
        Element root = document.getRootElement();
        Iterator it = root.elementIterator("module");
        while (it.hasNext()) {
            Element elm = (Element)it.next();
            String name = elm.attribute("name").getValue();
            SqlMapper.putMap(name, reader, null);
            Iterator children = elm.elementIterator("module");
            while (children.hasNext()) {
                Element childElm = (Element)children.next();
                String childname = childElm.attribute("name").getValue();
                SqlMapper.putMap(childname, reader, name);
            }
        }
    }

    private static void putMap(String name, SAXReader reader, String parent) throws Exception {
        InputStream moduleSql = SqlMapper.class.getClassLoader().getResourceAsStream(parent == null ? name + "/sql.xml" : parent + "/" + name + "/sql.xml");
        if (moduleSql != null) {
            Document docSql = reader.read(moduleSql);
            Element rootSql = docSql.getRootElement();
            Iterator item = rootSql.elementIterator("sql");
            while (item.hasNext()) {
                Element elmment = (Element)item.next();
                HashMap<String, String> logic = new HashMap<String, String>();
                String aliasSql = elmment.attribute("alias").getValue();
                logic.put("alias", aliasSql);
                String pathSql = elmment.attribute("path").getValue();
                logic.put("path", (parent == null ? name + "/sqls/" : parent + "/" + name + "/sqls/") + pathSql);
                String mobile = elmment.attributeValue("mobile");
                logic.put("mobile", mobile);
                if (map.containsKey(aliasSql)) {
                    throw new Exception("\u522b\u540d" + aliasSql + "\u5df2\u5b58\u5728");
                }
                map.put(aliasSql, logic);
            }
        }
    }

    public void main(String[] args) {
        SqlMapper.loadMap();
        for (String key : map.keySet()) {
            System.out.println(key);
        }
    }
}

