/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.af.plugins.RSAUtil;
import com.aote.filter.Config;
import com.aote.rs.mapper.WebException;
import com.aote.sql.SqlServer;
import com.aote.util.ExceptionHelper;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Path(value="sql")
@Component
@Transactional
public class SqlService {
    static Logger log = Logger.getLogger(SqlService.class);
    @Autowired
    private SqlServer sqlServer;

    @POST
    @Path(value="{name}/n")
    public String txgetTotalCnt(@PathParam(value="name") String name, String str) throws Exception {
        try {
            if (!str.startsWith("$")) {
                throw new WebException(500, "\u6570\u636e\u6709\u8bef");
            }
            str = RSAUtil.descrypt((String)str.substring(1));
            JSONObject result = this.sqlServer.queryTotal(name, str);
            return result.toString();
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            throw ex;
        }
    }

    @POST
    @Path(value="{name}")
    public String txExecute(@PathParam(value="name") String name, @QueryParam(value="pageNo") int pageNo, @QueryParam(value="pageSize") int pageSize, String str) throws Exception {
        try {
            if (str.startsWith("$")) {
                str = RSAUtil.descrypt((String)str.substring(1));
            } else if (!Config.encryptionCheck(str, "rs/sql/" + name)) {
                throw new WebException(500, "\u6570\u636e\u6709\u8bef");
            }
            log.error((Object)("\u89e3\u5bc6\u540e\u53c2\u6570\uff1a" + str));
            JSONArray result = this.sqlServer.query(name, pageNo, pageSize, str);
            return result.toString();
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            throw ex;
        }
    }

    @POST
    @Path(value="hql/{name}/n")
    public String txHqlgetTotalCnt(@PathParam(value="name") String name, String str) throws Exception {
        try {
            if (str.startsWith("$")) {
                str = RSAUtil.descrypt((String)str.substring(1));
            }
            JSONObject result = this.sqlServer.queryHqlTotal(name, str);
            return result.toString();
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            throw ex;
        }
    }

    @POST
    @Path(value="hql/{name}")
    public String txHqlExecute(@PathParam(value="name") String name, @QueryParam(value="pageNo") int pageNo, @QueryParam(value="pageSize") int pageSize, String str) throws Exception {
        try {
            if (str.startsWith("$")) {
                str = RSAUtil.descrypt((String)str.substring(1));
            } else if (!Config.encryptionCheck(str, "rs/hql/" + name)) {
                throw new WebException(500, "\u6570\u636e\u6709\u8bef");
            }
            JSONArray result = this.sqlServer.hqlQuery(name, pageNo, pageSize, str);
            return result.toString();
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            throw ex;
        }
    }

    @POST
    @Path(value="hql/{name}/all")
    public String txHqlExecuteAll(@PathParam(value="name") String name, @QueryParam(value="pageNo") int pageNo, @QueryParam(value="pageSize") int pageSize, String str) throws Exception {
        try {
            if (str.startsWith("$")) {
                str = RSAUtil.descrypt((String)str.substring(1));
            } else if (!Config.encryptionCheck(str, "rs/hql/" + name)) {
                throw new WebException(500, "\u6570\u636e\u6709\u8bef");
            }
            JSONArray result = this.sqlServer.hqlQueryAll(name, pageNo, pageSize, str);
            return result.toString();
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            throw ex;
        }
    }
}

