/*
 * Decompiled with CFR 0.152.
 */
package com.aote.filter;

import com.af.plugins.RedisTools;
import com.aote.filter.Config;
import com.aote.filter.ModifyResponseBodyWrapper;
import com.aote.filter.RSAUtil;
import com.aote.util.ResourceHelper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.web.filter.OncePerRequestFilter;
import redis.clients.jedis.Jedis;

public class ResponseFilter
extends OncePerRequestFilter {
    static Logger log = Logger.getLogger(ResponseFilter.class);
    private static String redispwd;
    public static String regex;

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        Long startTime = System.currentTimeMillis();
        Jedis jedis = null;
        ServletOutputStream out = null;
        String url = httpServletRequest.getRequestURI();
        log.debug((Object)("ResponseFilter:\u4f20\u5165\u7684URL:" + url));
        if (!Config.filterCheck(url)) {
            log.debug((Object)("ResponseFilter\u653e\u884cURL:" + url));
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        } else {
            try {
                String newResponseBody;
                ModifyResponseBodyWrapper modifyResponseBodyWrapper = new ModifyResponseBodyWrapper(httpServletResponse);
                filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)modifyResponseBodyWrapper);
                String oldResponseBody = modifyResponseBodyWrapper.getResponseBody();
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(oldResponseBody);
                if (matcher.find()) {
                    jedis = RedisTools.getJedis();
                    jedis.auth(redispwd);
                    String valString = jedis.get("DesensitizedUser");
                    String loginId = httpServletRequest.getHeader("Token");
                    boolean authorization = this.isAuthorization(valString, loginId);
                    log.debug((Object)("\u5f53\u524d\u7528\u6237:" + loginId + ",\u89e3\u654f\u6743\u9650:" + authorization));
                    newResponseBody = ResponseFilter.modifyResponseBody(oldResponseBody, authorization);
                } else {
                    newResponseBody = oldResponseBody;
                }
                httpServletResponse.setContentLength(newResponseBody.getBytes(StandardCharsets.UTF_8).length);
                httpServletResponse.setContentType(httpServletRequest.getContentType());
                byte[] responseBodyData = newResponseBody.getBytes(StandardCharsets.UTF_8);
                out = httpServletResponse.getOutputStream();
                out.write(responseBodyData);
                out.flush();
                Long endTime = System.currentTimeMillis();
                log.debug((Object)("ResponseFilter:" + url + ",\u62e6\u622a\u5668\u8017\u65f6:" + (endTime - startTime)));
            }
            catch (Exception e) {
                log.error((Object)"ResponseFilter\u62e6\u622a\u5668\u5f02\u5e38:", (Throwable)e);
                throw e;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    public static String modifyResponseBody(String originalBody, Boolean sensitive) {
        log.debug((Object)("modifyResponseBody\u83b7\u53d6\u5230:" + originalBody));
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(originalBody);
        StringBuffer sb = new StringBuffer(originalBody.length());
        String replacement = "****";
        while (matcher.find()) {
            String match = matcher.group(0);
            if (sensitive.booleanValue()) {
                try {
                    replacement = RSAUtil.aesDecrypt(match.replace("|-", "").replace("-|", ""), "7xjgtQc4M8FOXikU7JkwcUI0wKhYkREt");
                }
                catch (Exception e) {
                    log.debug((Object)"\u89e3\u5bc6\u5f02\u5e38", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        log.debug((Object)("modifyResponseBody\u8fd4\u56de:" + sb.toString()));
        return sb.toString();
    }

    public boolean isAuthorization(String ids, String id) {
        for (String item : ids.split(",")) {
            if (!item.equals(id)) continue;
            return true;
        }
        return false;
    }

    static {
        regex = "\\|-\\S*?(==|=)-\\|";
        try {
            JSONObject logicJsonObject;
            String url;
            String strConfig;
            JSONObject jsonObject;
            if (ResourceHelper.class.getResourceAsStream("/config.json") == null) {
                log.warn((Object)"\u65e0config.json\u6587\u4ef6\uff0c\u4e0d\u8fdb\u884credis\u7f13\u5b58");
            }
            if (!(jsonObject = new JSONObject(strConfig = ResourceHelper.getString("config.json"))).has("logicRegister")) {
                log.warn((Object)"\u65e0\u6a21\u5757\u955c\u50cf\uff0c\u4e0d\u8fdb\u884credis\u7f13\u5b58");
            }
            if ((url = (logicJsonObject = jsonObject.getJSONObject("logicRegister")).getString("url")) == null) {
                log.warn((Object)"\u65e0url\uff0c\u4e0d\u8fdb\u884credis\u7f13\u5b58");
            }
            JSONObject redisObject = logicJsonObject.getJSONObject("redis");
            try {
                redispwd = redisObject.getString("redispwd");
            }
            catch (JSONException e) {
                log.debug((Object)"\u65e0redis\u5bc6\u7801");
            }
        }
        catch (Exception e) {
            log.debug((Object)"\u83b7\u53d6redis\u5bc6\u7801\u5f02\u5e38", (Throwable)e);
        }
    }
}

