/*
 * Decompiled with CFR 0.152.
 */
package com.aote.filter;

import com.af.plugins.JwtUtil;
import com.aote.ThreadResource;
import com.aote.filter.Config;
import com.aote.filter.LoginFilter;
import com.aote.rs.mapper.WebException;
import com.aote.util.GetUserIp;
import com.aote.util.JwtUtilNew;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class LdapFilter
implements Filter {
    static Logger log = Logger.getLogger(LoginFilter.class);

    private String getCookie(HttpServletRequest request, String key) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : request.getCookies()) {
            if (!cookie.getName().equals(key)) continue;
            return cookie.getValue();
        }
        return null;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Long startTime = System.currentTimeMillis();
        try {
            ThreadResource.LoginUser.set(null);
            ThreadResource.ComponentDir.set(null);
            ThreadResource.Token.set(null);
            HttpServletRequest req = (HttpServletRequest)request;
            String ip = GetUserIp.getIpAdrress(req);
            String url = ip + req.getRequestURI();
            log.debug((Object)("\u4f20\u5165\u7684URL:" + url));
            boolean isOk = false;
            String Token = null;
            if (this.isPassUri(url)) {
                isOk = true;
                log.debug((Object)"\u8fdb\u5165\u6307\u5b9aurl\u653e\u884c\u4e86");
            } else if (req.getHeader("appToken") != null) {
                String appToken = req.getHeader("appToken");
                if (Objects.equals(appToken, "db4afb0c04ab4af0b5626998fe7c9b21")) {
                    log.debug((Object)"\u8fdb\u5165appToken\u653e\u884c\u4e86");
                    isOk = true;
                }
            } else if (req.getHeader("Authorization") != null) {
                JwtUtilNew jwtUtil;
                Token = req.getHeader("Authorization");
                log.debug((Object)("\u83b7\u53d6\u7684Authorization:" + Token));
                if (Token != null && (jwtUtil = new JwtUtilNew()).tokenVerify(Token = Token.substring(7))) {
                    isOk = true;
                }
            }
            if (!isOk) {
                log.debug((Object)("\u7528\u6237\u8ba4\u8bc1\u5931\u8d25URL:" + url));
                throw new WebException(401, "\u7528\u6237\u8ba4\u8bc1\u5931\u8d25\uff01");
            }
            String componentDir = req.getHeader("componentDir");
            log.debug((Object)("\u83b7\u53d6\u7684componentDir" + componentDir));
            if (componentDir != null) {
                ThreadResource.ComponentDir.set(componentDir);
            } else {
                String loginId = req.getHeader("Token");
                if (loginId != null) {
                    ThreadResource.Token.set(loginId);
                    String sessionId = req.getHeader("session");
                    ThreadResource.SessionId.set(sessionId == null ? null : new Integer(sessionId));
                }
            }
            log.debug((Object)("\u8fdb\u5165chain.doFilter:" + url));
            chain.doFilter(request, response);
            log.debug((Object)("\u7ed3\u675fchain.doFilter:" + url));
            Long endTime = System.currentTimeMillis();
            log.debug((Object)(url + ",\u62e6\u622a\u5668\u8017\u65f6:" + (endTime - startTime)));
        }
        catch (Exception e) {
            log.error((Object)"\u62e6\u622a\u5668\u5f02\u5e38:", (Throwable)e);
            throw e;
        }
    }

    public void destroy() {
    }

    public boolean isPassUri(String url) {
        for (String item : Config.config.getString("passurl_array").split("-")) {
            if (!url.contains(item)) continue;
            return true;
        }
        return false;
    }

    public String getLoginId(String token, String auth) {
        if (token != null) {
            return token;
        }
        if (auth != null) {
            auth = auth.substring(7);
            return new JwtUtil().getLoginId(auth);
        }
        return null;
    }
}

