/*
 * Decompiled with CFR 0.152.
 */
package com.aote.timer;

import com.af.plugins.JsonTools;
import com.aote.listener.KafkaConsumerListener;
import com.aote.logic.LogicServer;
import com.aote.module.ModuleMapper;
import com.aote.util.ResourceHelper;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
@Component
public class KafkaConsumerTimer {
    private static Logger log = Logger.getLogger(KafkaConsumerTimer.class);
    @Autowired
    private LogicServer logicServer;
    private Map<String, JSONArray> businessList = new HashMap<String, JSONArray>();
    private JSONArray jsonArray = new JSONArray();

    public KafkaConsumerTimer() {
        this.load();
    }

    public void load() {
        try {
            Map<String, Map<String, String>> map = ModuleMapper.getMap();
            for (String moduleName : map.keySet()) {
                if (ResourceHelper.class.getClassLoader().getResourceAsStream(moduleName + "/saveBusiness.json") == null) continue;
                JSONArray business = JsonTools.readJsonArrayFile((String)(moduleName + "/saveBusiness.json"));
                this.businessList.put(moduleName, business);
            }
        }
        catch (Exception e) {
            log.error((Object)"\u8bf7\u68c0\u67e5module.xml\u548cbusiness.json\u6587\u4ef6\u914d\u7f6e!");
            throw new RuntimeException(e);
        }
    }

    public void doBusiness() {
        JSONArray jsonArray = new JSONArray();
        KafkaConsumer<String, String> consumer = KafkaConsumerListener.getConsumer();
        ConsumerRecords records = consumer.poll(100L);
        for (ConsumerRecord record : records) {
            System.out.printf("offset = %d, key = %s, value = %s%n", record.offset(), record.key(), record.value());
            JSONObject jsonObject = new JSONObject(new String((String)record.value()));
            jsonArray.put((Object)jsonObject);
        }
        System.out.println(jsonArray.length());
        if (jsonArray.length() == 0) {
            return;
        }
        for (Map.Entry<String, JSONArray> entry : this.businessList.entrySet()) {
            String moduleName = entry.getKey();
            for (int i = 0; i < entry.getValue().length(); ++i) {
                JSONObject business = entry.getValue().getJSONObject(i);
                String businessName = business.getString("name");
                String logicName = business.getString("logicName");
                JSONObject data = new JSONObject();
                data.put("data", (Object)jsonArray);
                log.info((Object)("\u5f00\u59cb\u6267\u884c======\u6a21\u5757\uff1a\u3010" + moduleName + "\u3011==>\u3010" + businessName + "\u3011\u4e1a\u52a1======"));
                try {
                    this.logicServer.run(logicName, data);
                }
                catch (Exception e) {
                    log.info((Object)("\u6267\u884c\u5931\u8d25=====\u6a21\u5757\uff1a\u3010" + moduleName + "\u3011==>\u3010" + businessName + "\u3011\u4e1a\u52a1======"));
                    throw new RuntimeException(e);
                }
                log.info((Object)("\u6267\u884c\u6210\u529f======\u6a21\u5757\uff1a\u3010" + moduleName + "\u3011==>\u3010" + businessName + "\u3011\u4e1a\u52a1======"));
            }
        }
    }
}

