/*
 * Decompiled with CFR 0.152.
 */
package com.aote.filter;

import com.af.plugins.JwtUtil;
import com.af.plugins.RestTools;
import com.aote.ThreadResource;
import com.aote.filter.PassUrl;
import com.aote.rs.mapper.WebException;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class LoginFilter
implements Filter {
    static Logger log = Logger.getLogger(LoginFilter.class);

    private String getCookie(HttpServletRequest request, String key) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : request.getCookies()) {
            if (!cookie.getName().equals(key)) continue;
            return cookie.getValue();
        }
        return null;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String sessionId;
        ThreadResource.LoginUser.set(null);
        ThreadResource.ComponentDir.set(null);
        ThreadResource.Token.set(null);
        HttpServletRequest req = (HttpServletRequest)request;
        String url = req.getRequestURL().toString().toLowerCase();
        log.debug((Object)("\u4f20\u5165\u7684URL" + url));
        boolean isOk = false;
        String Token = null;
        if (this.isPassUri(url)) {
            isOk = true;
        } else if (req.getHeader("appToken") != null) {
            String appToken = req.getHeader("appToken");
            if (Objects.equals(appToken, "db4afb0c04ab4af0b5626998fe7c9b21")) {
                isOk = true;
            }
        } else if (req.getHeader("Authorization") != null) {
            JwtUtil jwtUtil;
            Token = req.getHeader("Authorization");
            log.debug((Object)("\u83b7\u53d6\u7684Token" + Token));
            if (Token != null && (jwtUtil = new JwtUtil()).tokenVerify(Token = Token.substring(7))) {
                isOk = true;
            }
        }
        if (!isOk) {
            throw new WebException(401, "\u7528\u6237\u8ba4\u8bc1\u5931\u8d25\uff01");
        }
        String loginId = this.getLoginId(req.getHeader("Token"), req.getHeader("Authorization"));
        if (loginId == null) {
            chain.doFilter(request, response);
            return;
        }
        if (req.getHeader("Token") != null) {
            Token = req.getHeader("Token");
        }
        if (Token != null) {
            ThreadResource.Token.set(Token);
        }
        ThreadResource.SessionId.set((sessionId = req.getHeader("session")) == null ? null : new Integer(sessionId));
        String componentDir = req.getHeader("componentDir");
        log.debug((Object)("\u83b7\u53d6\u7684componentDir" + componentDir));
        if (componentDir != null) {
            ThreadResource.ComponentDir.set(componentDir);
            chain.doFilter(request, response);
            return;
        }
        try {
            String str = RestTools.post((String)"/rs/search", (String)("{source:'this.getInfo()',userid:'" + loginId + "'}"));
            log.debug((Object)("\u7528\u6237\u4fe1\u606f\uff1a" + str));
            JSONObject json = new JSONObject(str);
            ThreadResource.LoginUser.set(json);
            String res = json.getString("dir");
            log.debug((Object)("\u7ec4\u4ef6\u76ee\u5f55\uff1a" + res));
            if (res != null && !"null".equals(res)) {
                ThreadResource.ComponentDir.set(res);
            }
            log.debug((Object)"\u8fdb\u5165chain.doFilter");
            chain.doFilter(request, response);
            log.debug((Object)"\u51fa\u5165chain.doFilter");
        }
        catch (ServletException e) {
            log.error((Object)"\u62e6\u622a\u5668\u65e5\u5fd7ServletException\uff1a", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            log.error((Object)"\u62e6\u622a\u5668\u65e5\u5fd7Throwable\uff1a", e);
            throw new ServletException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u9519\u8bef\uff0cToken=" + Token, e);
        }
    }

    public void destroy() {
    }

    public boolean isPassUri(String url) {
        for (String item : PassUrl.PASSURL_ARRAY) {
            if (!url.contains(item)) continue;
            return true;
        }
        return false;
    }

    public String getLoginId(String token, String auth) {
        if (token != null) {
            return token;
        }
        if (auth != null) {
            auth = auth.substring(7);
            return new JwtUtil().getLoginId(auth);
        }
        return null;
    }
}

