/*
 * Decompiled with CFR 0.152.
 */
package com.aote.filter;

import com.af.plugins.JwtUtil;
import com.aote.ThreadResource;
import com.aote.filter.PassUrl;
import com.aote.rs.mapper.WebException;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class LdapFilter
implements Filter {
    static Logger log = Logger.getLogger(LdapFilter.class);

    private String getCookie(HttpServletRequest request, String key) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : request.getCookies()) {
            if (!cookie.getName().equals(key)) continue;
            return cookie.getValue();
        }
        return null;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ThreadResource.LoginUser.set(null);
        ThreadResource.ComponentDir.set(null);
        ThreadResource.Token.set(null);
        HttpServletRequest req = (HttpServletRequest)request;
        String url = req.getRequestURL().toString().toLowerCase();
        log.debug((Object)("\u4f20\u5165\u7684URL" + url));
        boolean isOk = false;
        String Token = null;
        if (this.isPassUri(url)) {
            isOk = true;
        } else if (req.getHeader("appToken") != null) {
            String appToken = req.getHeader("appToken");
            if (Objects.equals(appToken, "db4afb0c04ab4af0b5626998fe7c9b21")) {
                isOk = true;
            }
        } else if (req.getHeader("Authorization") != null) {
            JwtUtil jwtUtil;
            Token = req.getHeader("Authorization");
            log.debug((Object)("\u83b7\u53d6\u7684Token" + Token));
            if (Token != null && (jwtUtil = new JwtUtil()).tokenVerify(Token = Token.substring(7))) {
                isOk = true;
            }
        }
        if (!isOk) {
            throw new WebException(401, "\u7528\u6237\u8ba4\u8bc1\u5931\u8d25\uff01");
        }
        log.debug((Object)"\u8fdb\u5165chain.doFilter");
        chain.doFilter(request, response);
        log.debug((Object)"\u51fa\u5165chain.doFilter");
    }

    public void destroy() {
    }

    public boolean isPassUri(String url) {
        for (String item : PassUrl.PASSURL_ARRAY) {
            if (!url.contains(item)) continue;
            return true;
        }
        return false;
    }

    public String getLoginId(String token, String auth) {
        if (token != null) {
            return token;
        }
        if (auth != null) {
            auth = auth.substring(7);
            return new JwtUtil().getLoginId(auth);
        }
        return null;
    }
}

