/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.path.PathMapper;
import com.aote.path.PathServer;
import com.aote.util.ExceptionHelper;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Path(value="path")
@Component
@Transactional
public class PathService {
    static Logger log = Logger.getLogger(PathService.class);
    @Autowired
    private PathServer pathServer;

    @POST
    @Path(value="{name}/n")
    public String txgetTotalCnt(@PathParam(value="name") String name, String str) throws Exception {
        try {
            JSONObject result = this.pathServer.queryTotal(name, str);
            return result.toString();
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            throw ex;
        }
    }

    @POST
    @Path(value="{name}")
    public String txPath(@PathParam(value="name") String name, @QueryParam(value="pageNo") int pageNo, @QueryParam(value="pageSize") int pageSize, String str) throws Exception {
        try {
            String level = PathMapper.getAttr(name, "log");
            if (level != null) {
                log.debug((Object)(name + ":" + str));
            }
            JSONArray result = this.pathServer.query(name, pageNo, pageSize, str);
            String ret = result.toString();
            if (level != null) {
                log.debug((Object)(name + ":" + ret));
            }
            return ret;
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            throw ex;
        }
    }
}

