/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.manager.DatabaseServer;
import com.aote.manager.LogicServer;
import com.aote.manager.SQLServer;
import com.aote.manager.VueServer;
import com.aote.util.ResourceHelper;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Path(value="manager")
@Component
public class ManagerService {
    static Logger log = Logger.getLogger(ManagerService.class);

    @GET
    @Path(value="database")
    public String getDatabase() {
        DatabaseServer server = new DatabaseServer();
        return server.getDatabases().toString();
    }

    @GET
    @Path(value="sql")
    public String getSQL() {
        SQLServer server = new SQLServer();
        return server.getData().toString();
    }

    @GET
    @Path(value="logic")
    public String getLogic() {
        LogicServer server = new LogicServer();
        return server.getData().toString();
    }

    @GET
    @Path(value="vue")
    public String getVue() {
        VueServer server = new VueServer();
        return server.getData().toString();
    }

    @GET
    @Path(value="config")
    public String getConfig() {
        String result = ResourceHelper.getString("config.json");
        result = result.replaceAll("#[^\n]*", "");
        return result;
    }

    public static JSONObject getJsonConfig() {
        ManagerService service = new ManagerService();
        return new JSONObject(service.getConfig());
    }
}

