/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.af.plugins.RSAUtil;
import com.aote.logic.LogicServer;
import com.aote.rs.mapper.WebException;
import com.aote.transaction.SessionPool;
import com.aote.util.ExceptionHelper;
import com.aote.util.JsonTransfer;
import java.util.Map;
import javassist.NotFoundException;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Path(value="logic")
@Singleton
@Component
public class LogicService {
    static Logger log = Logger.getLogger(LogicService.class);
    @Autowired
    private SessionPool sessionPool;
    @Autowired
    private LogicServer logicServer;

    public static void main(String[] args) {
    }

    @GET
    @Transactional
    @Path(value="{logic}")
    public String xtSave(@PathParam(value="logic") String logicName, @Context HttpServletRequest request) throws Exception {
        Map paramMap = request.getParameterMap();
        JSONObject params = new JSONObject(paramMap);
        return this.xtSave(logicName, params.toString());
    }

    @POST
    @Transactional
    @Path(value="{logic}")
    public String xtSave(@PathParam(value="logic") String logicName, String values) throws Exception {
        if (values.startsWith("$")) {
            values = RSAUtil.descrypt((String)values.substring(1));
        }
        log.debug((Object)("logic:" + logicName + ", values:" + values));
        return this.run(logicName, values);
    }

    private String run(String logicName, String values) throws Exception {
        try {
            JSONObject jsonObject = new JSONObject(values);
            if (jsonObject.has("action")) {
                int id = this.judgeAction(jsonObject);
                return id + "";
            }
            Object result = this.logicServer.run(logicName, values);
            if (result == null) {
                return "";
            }
            if (result instanceof Map) {
                Map map = (Map)result;
                JSONObject json = (JSONObject)new JsonTransfer().MapToJson(map);
                if (!json.isNull(" xml")) {
                    String jsStr = (String)json.get("xml");
                    return (String)json.get("xml");
                }
                return json.toString();
            }
            if (result instanceof JSONObject) {
                JSONObject json = (JSONObject)result;
                if (!json.isNull("xml")) {
                    String JSONstr = json.getString("xml");
                    return json.getString("xml");
                }
                return json.toString();
            }
            return result.toString();
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            WebException wex = this.getWebException(ex);
            if (wex != null) {
                throw wex;
            }
            throw ex;
        }
    }

    @POST
    @Path(value="noTransc/{logic}")
    public String save(@PathParam(value="logic") String logicName, String values) throws Exception {
        log.debug((Object)("logic:" + logicName + ", values:" + values));
        try {
            Object result = this.logicServer.noTranscRun(logicName, values);
            if (result == null) {
                return "";
            }
            if (result instanceof Map) {
                Map map = (Map)result;
                JSONObject json = (JSONObject)new JsonTransfer().MapToJson(map);
                if (!json.isNull("xml")) {
                    return (String)json.get("xml");
                }
                return json.toString();
            }
            if (result instanceof JSONObject) {
                JSONObject json = (JSONObject)result;
                if (!json.isNull("xml")) {
                    return json.getString("xml");
                }
                return json.toString();
            }
            return result.toString();
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            WebException wex = this.getWebException(ex);
            if (wex != null) {
                throw wex;
            }
            throw ex;
        }
    }

    private WebException getWebException(Exception ex) {
        for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof WebException)) continue;
            return (WebException)cause;
        }
        return null;
    }

    @PostConstruct
    public void redisCacheLogic() throws Exception {
        this.logicServer.redisCacheLogic();
    }

    private int judgeAction(JSONObject jsonObject) throws NotFoundException {
        int sessionid = 0;
        String actObj = (String)jsonObject.get("action");
        if ("begin".equals(actObj)) {
            sessionid = this.sessionPool.createSession();
            return sessionid;
        }
        sessionid = jsonObject.getInt("id");
        if ("commit".equals(jsonObject)) {
            this.sessionPool.commit(sessionid);
        } else if ("rollback".equals(jsonObject)) {
            this.sessionPool.rollback(sessionid);
        }
        return sessionid;
    }
}

