package com.aote.timer;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import com.aote.logic.LogicServer;

@Transactional
public class TaskJob {

	@Autowired
	private LogicServer logicServer;
	
	private List<ISource> sources;
	private CommonTarget commonTarget;
	private CommonCallBack commonCallBack;

	@SuppressWarnings("unchecked")
	public void run() {
		long startTime = System.currentTimeMillis();
		if (sources.size() > 0) {
			for (int i = 0; i < sources.size(); i++) {
				ISource source = sources.get(i);
				List<JSONArray> list = (List<JSONArray>) source.getSource();
				if (list != null && list.size() > 0) {
					List<JSONArray> resultList = null;
					if (list.size() > 0) {
						if (commonTarget == null) {
							commonCallBack.runCallBack(list);
						}else{
							resultList = commonTarget.sendTarget(list);
							if (resultList != null) {
								commonCallBack.runCallBack(resultList);
							}
						}
					}
				}
			}
		}
		long endTime = System.currentTimeMillis();
		System.out.println("run()方法本次耗时" + ((endTime - startTime) + "毫秒"));
	}
	
	public void runLogic(){
		List<String> logics = commonCallBack.getLogics();
		for (int i = 0; i < logics.size(); i++) {
			try {
				logicServer.run(logics.get(i), new JSONObject());
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	public List<ISource> getSources() {
		return sources;
	}

	public void setSources(List<ISource> sources) {
		this.sources = sources;
	}

	public void setCommonTarget(CommonTarget commonTarget) {
		this.commonTarget = commonTarget;
	}

	public void setCommonCallBack(CommonCallBack commonCallBack) {
		this.commonCallBack = commonCallBack;
	}

}
