package com.aote.rs;

import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;

import com.aote.util.AESUtil;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import com.aote.sql.SqlServer;
import com.aote.util.ExceptionHelper;

/**
 * 提供sql查询服务
 */
@Path("sql")
@Component
@Transactional
public class SqlService {
    static Logger log = Logger.getLogger(SqlService.class);

    @Autowired
    private SqlServer sqlServer;

    /**
     * 获取SQL语句的合计执行结果
     *
     * @param name : sql语句名
     * @param str  : sql语句执行参数
     */
    @POST
    @Path("{name}/n")
    public String txgetTotalCnt(@PathParam("name") String name, String str)
            throws Exception {
        try {
            boolean shouldEecrypt = str.startsWith("$");
            if (shouldEecrypt) {
                str = AESUtil.aesDecrypt(str.substring(1));
            }
            JSONObject result = sqlServer.queryTotal(name, str);
            if(shouldEecrypt){
                return result.toString();
            }else {
                return result.toString();
            }

        } catch (Exception ex) {
            log.error(ExceptionHelper.stackToString(ex));
            throw ex;
        }
    }

    /**
     * 执行sql,对sql中的参数进行替换 pageNo - 页号，默认为1 pageSize - 每页个数，默认为1000
     */
    @POST
    @Path("{name}")
    public String txExecute(@PathParam("name") String name,
                            @QueryParam("pageNo") int pageNo,
                            @QueryParam("pageSize") int pageSize, String str) throws Exception {
        try {
            boolean shouldEecrypt = str.startsWith("$");
            if (shouldEecrypt) {
                str = AESUtil.aesDecrypt(str.substring(1));
            }
            JSONArray result = sqlServer.query(name, pageNo, pageSize, str);
            if(shouldEecrypt){
                return result.toString();
            }else {
                return result.toString();
            }
        } catch (Exception ex) {
            log.error(ExceptionHelper.stackToString(ex));
            throw ex;
        }
    }

    /**
     * 获取HQL语句的合计执行结果
     *
     * @param name : hql语句名
     * @param str  : hql语句执行参数
     */
    @POST
    @Path("hql/{name}/n")
    public String txHqlgetTotalCnt(@PathParam("name") String name, String str)
            throws Exception {
        try {
            boolean shouldEecrypt = str.startsWith("$");
            if (shouldEecrypt) {
                str = AESUtil.aesDecrypt(str.substring(1));
            }
            JSONObject result = sqlServer.queryHqlTotal(name, str);
            if(shouldEecrypt){
                return result.toString();
            }else {
                return result.toString();
            }
        } catch (Exception ex) {
            log.error(ExceptionHelper.stackToString(ex));
            throw ex;
        }
    }

    /**
     * 执行hql,对hql中的参数进行替换 pageNo - 页号，默认为1 pageSize - 每页个数，默认为1000
     */
    @POST
    @Path("hql/{name}")
    public String txHqlExecute(@PathParam("name") String name,
                               @QueryParam("pageNo") int pageNo,
                               @QueryParam("pageSize") int pageSize, String str) throws Exception {
        try {
            boolean shouldEecrypt = str.startsWith("$");
            if (shouldEecrypt) {
                str = AESUtil.aesDecrypt(str.substring(1));
            }
            JSONArray result = sqlServer.hqlQuery(name, pageNo, pageSize, str);
            if(shouldEecrypt){
                return result.toString();
            }else {
                return result.toString();
            }
        } catch (Exception ex) {
            log.error(ExceptionHelper.stackToString(ex));
            throw ex;
        }
    }
}
