package com.aote.rs;

import javax.ws.rs.GET;
import javax.ws.rs.Path;

import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

import com.aote.manager.DatabaseServer;
import com.aote.manager.LogicServer;
import com.aote.manager.SQLServer;
import com.aote.manager.VueServer;
import com.aote.util.ResourceHelper;

/**
 * 提供sql查询服务
 */
@Path("manager")
@Component
public class ManagerService {
	static Logger log = Logger.getLogger(ManagerService.class);

	/**
	 * 从hibernate中读取数据库表信息
	 */
	@GET
	@Path("database")
	public String getDatabase()
			throws Exception {
		DatabaseServer server = new DatabaseServer();
		String result = server.getDatabases().toString();
		return result;
	}
	
	/**
	 * 获取SQL语句信息
	 */
	@GET
	@Path("sql")
	public String getSQL() throws Exception {
		SQLServer server = new SQLServer();
		String result = server.getData().toString();
		return result;
	}
	
	/**
	 * 获取业务逻辑信息
	 */
	@GET
	@Path("logic")
	public String getLogic() throws Exception {
		LogicServer server = new LogicServer();
		String result = server.getData().toString();
		return result;
	}
	
	/**
	 * 获取前台组件信息
	 */
	@GET
	@Path("vue")
	public String getVue() throws Exception {
		VueServer server = new VueServer();
		String result = server.getData().toString();
		return result;
	}
	
	/**
	 * 获取系统环境运行配置信息
	 */
	@GET
	@Path("config")
	public String getConfig() throws Exception {
		String result = ResourceHelper.getString("config.json");
		// 去掉json中的注释
		result = result.replaceAll("#[^\n]*", "");
		return result;
	}
}
