package com.aote.rs;

import java.util.Map;

import javax.inject.Singleton;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;

import com.aote.util.AESUtil;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import com.aote.logic.LogicServer;
import com.aote.rs.mapper.WebException;
import com.aote.util.ExceptionHelper;
import com.aote.util.JsonTransfer;

@Path("logic")
@Singleton
@Component
public class LogicService {
	static Logger log = Logger.getLogger(LogicService.class);

	@Autowired
	private LogicServer logicServer;

	/**
	 * 执行业务逻辑
	 * 
	 * @param logicName
	 * @param values
	 * @return
	 */
	@POST
	@Transactional
	@Path("{logic}")
	public String xtSave(@PathParam("logic") String logicName, String values)
			throws Exception {
		boolean shouldEecrypt = values.startsWith("$");
		String resultEecrypt;
		if (shouldEecrypt) {
			values = AESUtil.aesDecrypt(values.substring(1));
		}
		log.debug("logic:" + logicName + ", values:" + values);
		try {
			Object result = logicServer.run(logicName, values);
			if (result == null) {
				resultEecrypt =  "";
			// 如果执行结果为Map，转换成JSON串
			}else if (result instanceof Map<?, ?>) {
				Map<String, Object> map = (Map<String, Object>)result;
				JSONObject json = (JSONObject) new JsonTransfer().MapToJson(map);
				if (json.isNull("xml") == false) {
					String xml = (String) json.get("xml");
					resultEecrypt =  xml;
				}else {
					resultEecrypt = json.toString();
				}
			}else if (result instanceof JSONObject) {
				JSONObject json = (JSONObject) result;
				if (json.isNull("xml") == false) {
					String xml = json.getString("xml");
					resultEecrypt =  xml;
				}else {
					resultEecrypt = json.toString();
				}
			}else {
				resultEecrypt = result.toString();
			}
			if(shouldEecrypt){
				return  resultEecrypt;
			}else {
				return AESUtil.aesEncrypt(resultEecrypt);
			}
		} catch (Exception ex) {
			log.error(ExceptionHelper.stackToString(ex));
			WebException wex = this.getWebException(ex);
			if (wex != null) 
			{
				throw wex;
			}
			throw ex;
		}
	}
	
	@POST
	@Path("noTransc/{logic}")
	public String save(@PathParam("logic") String logicName, String values)
			throws Exception {
		boolean shouldEecrypt = values.startsWith("$");
		String resultEecrypt;
		if (shouldEecrypt) {
			values = AESUtil.aesDecrypt(values.substring(1));
		}
		log.debug("logic:" + logicName + ", values:" + values);
		try {
			Object result = logicServer.noTranscRun(logicName, values);
			if (result == null) {
				resultEecrypt = "";

			// 如果执行结果为Map，转换成JSON串
			}else if (result instanceof Map<?, ?>) {
				Map<String, Object> map = (Map<String, Object>)result;
				JSONObject json = (JSONObject) new JsonTransfer().MapToJson(map);
				if (json.isNull("xml") == false) {
					String xml = (String) json.get("xml");
					resultEecrypt =  xml;
				}else{
					resultEecrypt =  json.toString();
				}

			}else if (result instanceof JSONObject) {
				JSONObject json = (JSONObject) result;
				if (json.isNull("xml") == false) {
					String xml = json.getString("xml");
					resultEecrypt =  xml;
				}else {
					resultEecrypt =  json.toString();
				}

			}else {
				resultEecrypt = result.toString();
			}
			if(shouldEecrypt){
				return  resultEecrypt;
			}else {
				return AESUtil.aesEncrypt(resultEecrypt);
			}
		} catch (Exception ex) {
			log.error(ExceptionHelper.stackToString(ex));
			WebException wex = this.getWebException(ex);
			if (wex != null) 
			{
				throw wex;
			}
			throw ex;
		}
	}
	
	// 找到WebException异常
	// return - 不存在，返回null
	private WebException getWebException(Exception ex)
	{
		Throwable cause = ex;
		while (cause != null)
		{
			if (cause instanceof WebException)
			{
				return (WebException)cause;
			}
			cause = cause.getCause();
		}
		
		return null;
	}
}
