/*
 * Decompiled with CFR 0.152.
 */
package com.aote.plugin;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.json.JSONObject;

public class DatePlugin {
    public String getNow() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatter.format(new Date());
    }

    public String getNextMinute(int count) {
        Calendar c = Calendar.getInstance();
        c.add(12, count);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatter.format(c.getTime());
    }

    public String getNextDay(int count) {
        Calendar c = Calendar.getInstance();
        c.add(5, count);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatter.format(c.getTime());
    }

    public static JSONObject computeDate(int stairmonths) {
        String startDate;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String endDate = formatter.format(new Date());
        Calendar cal = Calendar.getInstance();
        int year = Integer.parseInt(endDate.substring(0, 4));
        int month = Integer.parseInt(endDate.substring(5, 7));
        int day = Integer.parseInt(endDate.substring(8, 10));
        cal.set(year, month - 1, day);
        int thismonth = cal.get(2);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if (stairmonths == 1) {
            cal.set(5, 1);
            startDate = format.format(cal.getTime());
            cal.set(5, cal.getActualMaximum(5));
            endDate = format.format(cal.getTime());
        } else if (stairmonths == 0) {
            startDate = "";
            endDate = "";
        } else {
            if (thismonth == 12) {
                thismonth = 11;
            }
            int star = Math.round(thismonth / stairmonths) * stairmonths + 1;
            int end = Math.round(thismonth / stairmonths) * stairmonths + stairmonths;
            cal.set(2, star - 1);
            cal.set(5, 1);
            startDate = format.format(cal.getTime());
            cal.set(2, end - 1);
            cal.set(5, cal.getActualMaximum(5));
            endDate = format.format(cal.getTime());
        }
        JSONObject jo = new JSONObject();
        jo.put("startDate", (Object)startDate);
        jo.put("endDate", (Object)endDate);
        return jo;
    }

    public String format(String dt, String pattern) {
        try {
            Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dt);
            return new SimpleDateFormat(pattern).format(date);
        }
        catch (Exception e) {
            System.out.println("\u683c\u5f0f\u5316\u65e5\u671f\u5b57\u7b26\u4e32\u5931\u8d25!");
            return null;
        }
    }
}

