package com.aote.report;

import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.aote.entity.EntityServer;
import com.aote.sql.SqlServer;
import com.aote.util.ExpressionHelper;
import com.aote.util.ResourceHelper;

@Component
public class ReportServer {
	static Logger log = Logger.getLogger(ReportServer.class);

	@Autowired
	private SqlServer sqlServer;

	// 执行业务逻辑处理过程
	public Object run(String name, String str) throws Exception {
		// 获取报表内容
		String path = ReportMapper.getReport(name);
		if (path == null) {
			throw new RuntimeException("报表未注册：" + name);
		}
		// 如果path本身有"/", 不加report部分
		if (!path.startsWith("/")) {
			path = "/reports/" + path;
		}

		String source = ResourceHelper.getString(path);
		// 加载报表
		Report report = new Report(source, str);
		report.sqlServer = this.sqlServer;
		return report.render();
	}
}
