package com.aote.report;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import com.aote.ThreadResource;
import com.aote.logic.LogicMapper;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import com.aote.sql.SqlMapper;

/**
 * logic映射器
 * @author HNS
 *
 */
public class ReportMapper {

	static Logger log = Logger.getLogger(ReportMapper.class);
	
	private static Map<String, String> map;
	
	public static synchronized String getReport(String alias)
	{
		if(map == null)
			loadMap();
		if(map.containsKey(alias)) {
			// 如果登录用户有特殊报表，返回
			String result = getReportByUser(alias);
			if(result != null) {
				return result;
			}
			return map.get(alias);
		}
		else
			return null;
	}

	/**
	 * 根据登录用户，取报表目录，没有找到，返回空
	 * @param alias
	 * @return
	 */
	private static String getReportByUser(String alias) {
		// 从线程变量里获取登录用户目录名
		String dir = ThreadResource.ComponentDir.get();
		if (dir == null) {
			return null;
		}
		// 看对应目录下有没有给定报表内容
		String path = "/" + dir + "/reports/" + alias + ".rpt.xml";
		if (ReportMapper.class.getResource(path) != null) {
			return path;
		}
		return null;
	}

	@SuppressWarnings("rawtypes")
	private static void loadMap() {
		map = new HashMap<String, String>();

		SAXReader reader = new SAXReader();
		InputStream input = SqlMapper.class.getClassLoader().getResourceAsStream("report.xml");
		try {
			Document document = reader.read(input);
			Element root = document.getRootElement();
			for (Iterator it = root.elementIterator("report"); it.hasNext();) {
				Element elm = (Element) it.next();
				String alias = elm.attribute("alias").getValue();
				String path = elm.attribute("path").getValue();
				map.put(alias, path);
			}
		} catch (DocumentException ex) {
			throw new RuntimeException(ex);
		}
	}
	
	public void main(String[] args) {
		ReportMapper.loadMap();
		for(String key : map.keySet())
			System.out.println(key);
	}
}
