package com.aote.report;

import java.util.ArrayList;
import java.util.List;

import org.dom4j.Element;
import org.json.JSONArray;

import com.af.expression.Delegate;
import com.af.expression.Program;

// 表体数据库，每个块有两个数据集，头部数据集，左边数据集。
public class BodyBlock extends Block {
	// 头部数据表达式及编译结果
	public String headExpression;

	public Delegate headDelegate;

	// 左边数据表达式及编译结果
	public String leftExpression;

	public Delegate leftDelegate;

	// 重复数据的名称
	public String leftName;
	public String headName;
	
	// 单元格表达式中head及left对应的对象
	public Object head;
	public Object left;

	// 从xml元素构造
	public BodyBlock(Element ele) {
		super(ele);
		// 加载头及左表达式
		this.headExpression = ele.attributeValue("headexpression");
		this.leftExpression = ele.attributeValue("leftexpression");
		// 获取重复数据的名称
		this.leftName = ele.attributeValue("leftname");
		this.headName = ele.attributeValue("headname");

		// 加载子块
		for (Object obj : ele.elements("bodyblock")) {
			Element e = (Element) obj;
			this.cells.add(new BodyBlock(e));
		}
	}

	public BodyBlock(int row, int column, int rowSpan, int columnSpan,
			String headExpression, String leftExpression) {
		super(row, column, rowSpan, columnSpan, null);
		this.headExpression = headExpression;
		this.leftExpression = leftExpression;
	}

	// 重置块的起始行、列
	public void setRowColumn(int row, int column) {
		// 对块中的每一个单元格，更改列号，如果是块，要递归做
		for (Cell cell : cells) {
			cell.row = cell.row + row;
			cell.column = cell.column + column;
			if (cell instanceof BodyBlock) {
				BodyBlock block = (BodyBlock) cell;
				block.setRowColumn(row, column);
			}
		}
	}

	@Override
	public void compile() {
		super.compile();
		// 对头及左部表达式进行编译
		if (this.headExpression != null
				&& !this.headExpression.trim().equals("")) {
			Program prog = new Program(this.headExpression);
			this.headDelegate = prog.parse();
		}
		if (this.leftExpression != null
				&& !this.leftExpression.trim().equals("")) {
			Program prog = new Program(this.leftExpression);
			this.leftDelegate = prog.parse();
		}
	}

	// 根据块的数据，产生可以使用的单元格
	// result - 创建的单元格存放在result里
	// return - 复制了多少行
	public Ret createCell(List<Cell> result) {
		// 对单元格按行列进行排序，把同一行放在一起
		cells.sort((o1, o2) -> (o1.row * 10000 + o1.column)
				- (o2.row * 10000 + o2.column));

		// 复制了多少行，多少列
		int copyRow = 0;
		int copyColumn = 0;
		int oldCopyRow = 0;
		// 对所有排序了的单元格（包括块），重新计算行、列
		Cell oldCell = cells.get(0);
		for (Cell cell : cells) {
			// 如果换行了，copyColumn重新计算，copyRow累加。
			// 否则，copyRow为上一个值，copyColumn累加
			if (cell.column <= oldCell.column) {
				copyColumn = 0;
				oldCopyRow = copyRow;
			} else {
				copyRow = oldCopyRow;
			}
			oldCell = cell;

			// 如果是block
			if (cell instanceof BodyBlock) {
				BodyBlock block = (BodyBlock) cell;
				// 如果行、列都可复制
				if (block.headDelegate != null
						&& block.leftDelegate != null) {
					int i = 0;
					JSONArray headData = this.getHeadArray(block);
					JSONArray leftData = this.getLeftArray(block);
					for (Object leftItem : leftData) {
						if (i != 0) {
							copyRow += block.rowSpan;
						}
						int j = 0;
						int cellCopyRow = 0;
						copyColumn = 0;
						for (Object headItem : headData) {
							BodyBlock newBlock = block.clone();
							// 第一块只加增加的行数，第二块要加上块本身的行数
							if (j != 0) {
								copyColumn += block.rowSpan;
							}
							// 设置块的起始列
							newBlock.setRowColumn(copyRow, copyColumn);
							// 让新的块产生单元格
							List<Cell> cells = new ArrayList<Cell>();
							// 设置block中head、left对象
							newBlock.head = headItem;
							newBlock.left = leftItem;
							// 设置表达式中的head，left对象
							this.report.vars.put(newBlock.headName, headItem);
							this.report.vars.put(newBlock.leftName, leftItem);

							Ret ret = newBlock.createCell(cells);
							cellCopyRow = ret.copyRow;
							copyColumn += ret.copyColumn;
							result.addAll(cells);

							j++;
						}
						copyRow += cellCopyRow;
						i++;
					}
				}
				// 如果列可复制
				else if (block.headDelegate != null
						&& block.leftDelegate == null) {
					int i = 0;
					JSONArray headData = (JSONArray) block.headDelegate
							.invoke(block.report.vars);
					int cellCopyRow = 0;
					for (Object headItem : headData) {
						if (i != 0) {
							copyColumn += block.columnSpan;
						}
						BodyBlock newBlock = block.clone();
						// 设置块的起始列
						newBlock.setRowColumn(copyRow, copyColumn);
						// 让新的块产生单元格
						List<Cell> cells = new ArrayList<Cell>();
						newBlock.head = headItem;
						// 设置表达式中的head，left对象
						this.report.vars.put(newBlock.headName, headItem);

						Ret ret = newBlock.createCell(cells);
						cellCopyRow = ret.copyRow;
						copyColumn += ret.copyColumn;
						result.addAll(cells);

						i++;
					}
					copyRow += cellCopyRow;
				}
				// 如果行可复制
				else if (block.leftDelegate != null
						&& block.headDelegate == null) {
					int i = 0;
					JSONArray leftData = (JSONArray) block.leftDelegate
							.invoke(block.report.vars);
					for (Object leftItem : leftData) {
						if (i != 0) {
							copyRow += block.rowSpan;
						}
						BodyBlock newBlock = block.clone();
						// 设置块的起始列
						newBlock.setRowColumn(copyRow, copyColumn);
						// 让新的块产生单元格
						List<Cell> cells = new ArrayList<Cell>();
						newBlock.left = leftItem;
						// 设置表达式中的head，left对象
						this.report.vars.put(newBlock.leftName, leftItem);

						Ret ret = newBlock.createCell(cells);
						copyRow += ret.copyRow;
						copyColumn += ret.copyColumn;
						result.addAll(cells);

						i++;
					}
				}
				// 不可复制块
				else {
					// 不可复制的block，直接把block内容拿处理即可
					BodyBlock newBlock = block.clone();
					// 设置块的起始列
					newBlock.setRowColumn(copyRow, copyColumn);
					// 让新的块产生单元格
					List<Cell> cells = new ArrayList<Cell>();
					Ret ret = newBlock.createCell(cells);
					copyRow += ret.copyRow;
					copyColumn += ret.copyColumn;
					result.addAll(cells);
				}
			} else {
				cell.row = cell.row + copyRow;
				cell.column = cell.column + copyColumn;
				cell.content = cell.invoke().toString();
				result.add(cell);
			}
		}

		return new Ret(copyRow, copyColumn);
	}

	// 获取head部分数据计算结果，可以计算出来是单个对象，把单个对象放到数组里
	private JSONArray getHeadArray(BodyBlock block) {
		block.report.vars.put("head", head);
		block.report.vars.put("left", left);
		Object headObject = block.headDelegate.invoke(block.report.vars);
		if (headObject instanceof JSONArray) {
			return (JSONArray) headObject;
		} else {
			JSONArray result = new JSONArray();
			result.put(headObject);
			return result;
		}
	}

	// 获取left部分数据计算结果，可以计算出来是单个对象，把单个对象放到数组里
	private JSONArray getLeftArray(BodyBlock block) {
		block.report.vars.put("head", head);
		block.report.vars.put("left", left);
		Object leftObject = block.leftDelegate.invoke(block.report.vars);
		if (leftObject instanceof JSONArray) {
			return (JSONArray) leftObject;
		} else {
			JSONArray result = new JSONArray();
			result.put(leftObject);
			return result;
		}
	}

	// 复制
	public BodyBlock clone() {
		BodyBlock result = new BodyBlock(this.row, this.column, this.rowSpan,
				this.columnSpan, this.headExpression, this.leftExpression);
		if (this.report != null) {
			result.report = this.report;
		}

		// 复制单元格
		for (Cell cell : cells) {
			result.cells.add(cell.clone());
		}

		// 复制编译结果
		if (this.headDelegate != null) {
			result.headDelegate = this.headDelegate;
		}
		if (this.leftDelegate != null) {
			result.leftDelegate = this.leftDelegate;
		}
		
		if (this.headName != null) {
			result.headName = this.headName;
		}
		if (this.leftName != null) {
			result.leftName = this.leftName;
		}

		return result;
	}
}
