package com.aote.report;

import java.util.ArrayList;
import java.util.List;

import org.dom4j.Element;

// 包含单元格及其它块的结构
// HeadBlock, LeftBlock, BodyBlock, ReportBlock都从这里继承
public class Block extends Cell {
	// 组成块的单元格，包括子块
	public List<Cell> cells = new ArrayList<Cell>();
	
	// 从xml元素构造
	public Block(Element ele) {
		super(ele);
		// 加载所有独立单元格
		for (Object obj : ele.elements("cell")) {
			Element e = (Element)obj;
			this.cells.add(new Cell(e));
		}
	}
	
	public Block(int row, int column, int rowSpan, int columnSpan, String content) {
		super(row, column, rowSpan, columnSpan, content);
	}
	
	// 对组成块的单元格，以及块进行编译
	@Override
	public void compile() {
		super.compile();
		// 对子块进行编译
		for (Cell cell : cells) {
			cell.compile();
		}
	}
	
	@Override
	public void setReport(Report report) {
		super.setReport(report);
		for (Cell cell : cells) {
			cell.setReport(report);
		}
	}
}
