package com.aote.plugin;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 
 * @author zhaotong 本类主要是为业务层提供一些数据支持，如：产生随机数，产生ID，等等。
 *         修改本类是不得改变已有函数，可重新添加，或者将原有函数包装。 每个函数必须说明作者，参数，返回值，主要功能。
 */
public class NumberUtil {

	/**
	 * @author zhaotong 本函数主要为逻辑提供连续的5位数，用来给数据库某字段进行标记
	 * @param start
	 *            起始序号
	 * @param count
	 *            产生数量
	 * @return List<String>
	 */
	public static List<String> getNumberMark(String start, String count) {
		int s = Integer.parseInt(start);
		int c = Integer.parseInt(count);
		return getNumberMark(s, c);
	}

	/**
	 * @author zhaotong 本函数主要为逻辑提供连续的5位数，用来给数据库某字段进行标记(参数均为int)
	 * @param start
	 *            起始序号
	 * @param count
	 *            产生数量
	 * @return List<String>
	 */
	public static List<String> getNumberMark(int start, int count) {
		List<String> list = new ArrayList<String>();
		for (int i = 1; i <= count; i++) {
			list.add(getNumberFormat(start) + i);
		}

		return list;
	}

	public static String getNumberFormat(int num) {
		return String.format("%05d", num);
	}

	/**
	 * 数字千分号转换
	 * @param num
	 *            转换数字
	 */
	public static String seg(Object num) {
		if (num == null) {
			return "0";
		}
	
		String investPrice=NumberFormat.getCurrencyInstance().format(num);

		return investPrice.replace("￥", "");
	}
	/**
	 * 数字为0转换为空字符串
	 * @param num
	 *            转换数字
	 */
	public static String isnull(Object num) {
		if (num == null) {
			return " ";
		}
		try {
			if (Double.parseDouble(num.toString())==0){
				return " ";
			}
		}catch (Exception e){
			return num.toString();
		}
		return num.toString();
	}
	/**
	 * 将指定字符串转换为空字符串
	 * @param num
	 *            转换数字
	 */
	public static String isnull(Object num,String flag) {
		if (num == null) {
			return " ";
		}
		if (flag == null || flag.trim().isEmpty()) {
			return num.toString();
		}
		Pattern pattern = Pattern.compile("[0-9]*\\.?[0-9]+");
		Matcher isNum1 = pattern.matcher(num.toString());
		Matcher isNum2 = pattern.matcher(flag);
		if(isNum1.matches() && isNum2.matches() && Double.parseDouble(flag)==Double.parseDouble(num.toString())){
			return " ";
		}
		if(!isNum1.matches() && !isNum2.matches() && num.toString().equals(flag)){
			return " ";
		}
		return num.toString();
	}
	public static Double isNum(Object num,String flag){
//		flag==‘null’ 返回 null
		if(num ==null || num.toString().trim().isEmpty()){
			if(flag==null || flag.equals("null")){
				return null;
			}
			return 0.00;
		}
		Pattern pattern = Pattern.compile("[0-9]*\\.?[0-9]+");
		Matcher isNum = pattern.matcher(num.toString());
		if(isNum.matches()){
			return Double.parseDouble(num.toString());
		}else{
			if(flag==null || flag.equals("null")){
				return null;
			}
			return 0.00;
		}
	}
	/**
	 * 数字分节  
	 * @param num  
	 *            转换数字
	 */
	public static String getNumFor(int x,Object num) {
		if (num == null) {
			return "0";
		}
		DecimalFormat df1=(DecimalFormat) DecimalFormat.getInstance(); 
		df1.setGroupingSize(x); 
		return df1.format(Long.valueOf(num.toString()));
	}

	/**
	 * 获取两数的百分比
	 * @param a
	 * @param b
	 * @return
	 */
	public static String getPercent(BigDecimal a, BigDecimal b){
		BigDecimal c = new BigDecimal(0);
		if(a.compareTo(c)==0 || b.compareTo(c) == 0){
			return "0.00%";
		}else{
			BigDecimal d = a.divide(b, 2, BigDecimal.ROUND_HALF_UP);
			String s = d.toString();
			String perc = s.substring(2)+'%';
			return perc;
		}
	}

	public static String getPercent(int a,int b){
		if(a==0 || b==0){
			return "0.00%";
		}else {
			float num = (float)a/b;
			DecimalFormat df = new DecimalFormat("0.00");
			String s = df.format(num);
			String ss = s.substring(2)+'%';
			return ss;
		}
	}

	//NumberFormatter
	public static void main(String[] args) {

		/**
		 * @author zhaotong getNumberMark 测试
		 */
		System.out.println(NumberUtil.isNum("4564a", ""));
	}

}
