/*
 * Decompiled with CFR 0.152.
 */
package com.aote.report;

import com.af.expression.Delegate;
import com.af.expression.Program;
import com.aote.logic.PluginMapper;
import com.aote.report.Cell;
import com.aote.report.ReportBlock;
import com.aote.report.Sql;
import com.aote.sql.SqlServer;
import com.aote.util.JsonHelper;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class Report {
    public SqlServer sqlServer;
    public List<Sql> sqls = new ArrayList<Sql>();
    public List<Cell> cells = new ArrayList<Cell>();
    public Map<String, Object> vars = new HashMap<String, Object>();

    public Report(Map<String, Object> vars) {
        this.vars = vars;
    }

    public Report(String vars) throws Exception {
        JSONObject json = new JSONObject(vars);
        this.vars = JsonHelper.toMap((JSONObject)json);
    }

    public Report(String source, String vars) throws Exception {
        this.load(source);
        JSONObject json = new JSONObject(vars);
        JSONObject data = json.getJSONObject("data");
        this.vars = JsonHelper.toMap((JSONObject)data);
        Map plugins = PluginMapper.getPlugins();
        for (String key : plugins.keySet()) {
            this.vars.put(key, plugins.get(key));
        }
    }

    public Report() {
    }

    public String render() throws Exception {
        this.procSqls();
        this.compile();
        for (Cell cell : this.cells) {
            cell.setReport(this);
        }
        List<Cell> result = this.createCells();
        Document doc = DocumentHelper.createDocument();
        Element table = this.layout(doc, result);
        String str = table.asXML();
        return str;
    }

    private void load(String source) {
        SAXReader reader = new SAXReader();
        try {
            Element ele;
            Document document = reader.read((Reader)new StringReader(source));
            Element root = document.getRootElement();
            for (Object obj : root.elements("sql")) {
                ele = (Element)obj;
                this.sqls.add(new Sql(ele));
            }
            for (Object obj : root.elements("cell")) {
                ele = (Element)obj;
                this.cells.add(new Cell(ele));
            }
            for (Object obj : root.elements("reportblock")) {
                ele = (Element)obj;
                this.cells.add(new ReportBlock(ele));
            }
        }
        catch (DocumentException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void procSqls() throws Exception {
        for (Sql sql : this.sqls) {
            Program proc = new Program(sql.param);
            Delegate delegate = proc.parse();
            JSONObject json = (JSONObject)delegate.invoke(this.vars);
            JSONArray ret = this.sqlServer.query(sql.sql, json);
            this.vars.put(sql.name, ret);
        }
    }

    public void compile() {
        for (Cell cell : this.cells) {
            cell.compile();
        }
    }

    public List<Cell> createCells() {
        ArrayList<Cell> result = new ArrayList<Cell>();
        this.cells.sort((o1, o2) -> o1.row * 10000 + o1.column - (o2.row * 10000 + o2.column));
        int copyRow = 0;
        for (Cell cell : this.cells) {
            if (cell instanceof ReportBlock) {
                ReportBlock block = (ReportBlock)cell;
                block.setRow(copyRow);
                copyRow += block.createCell(result);
                continue;
            }
            if (!"false".equals(cell.isDown)) {
                cell.row += copyRow;
            }
            cell.content = cell.invoke().toString();
            result.add(cell);
        }
        return result;
    }

    public Element layout(Document doc, List<Cell> cells) {
        Element eTable = doc.addElement("table");
        eTable.addAttribute("class", "tableprint");
        cells.sort((o1, o2) -> o1.row * 10000 + o1.column - (o2.row * 10000 + o2.column));
        int currentRow = -1;
        Element eTr = null;
        for (Cell cell : cells) {
            if (cell.row != currentRow) {
                eTr = eTable.addElement("tr");
                currentRow = cell.row;
            }
            Element eTd = eTr.addElement("td");
            if (cell.css != null && !cell.css.equals("")) {
                eTd.addAttribute("class", cell.css);
            }
            if (cell.width != null && !cell.width.equals("")) {
                eTd.addAttribute("width", cell.width);
            }
            if (cell.height != null && !cell.height.equals("")) {
                eTd.addAttribute("height", cell.height);
            }
            if (cell.columnSpan > 1) {
                eTd.addAttribute("colspan", cell.columnSpan + "");
            }
            if (cell.rowSpan > 1) {
                eTd.addAttribute("rowspan", cell.rowSpan + "");
            }
            if (cell.type != null && cell.type.equals("html")) {
                SAXReader reader = new SAXReader();
                try {
                    Document document = reader.read((Reader)new StringReader(cell.content));
                    Element root = document.getRootElement();
                    eTd.add(root);
                    continue;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            eTd.addText(cell.content);
        }
        return eTable;
    }
}

