/*
 * Decompiled with CFR 0.152.
 */
package com.aote.report;

import com.aote.report.Block;
import com.aote.report.Cell;
import com.aote.report.Report;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;
import org.json.JSONArray;

public class LeftBlock
extends Block {
    public Cell headCell;
    public Object data;
    public String name;

    public LeftBlock(Element ele) {
        super(ele);
        for (Object obj : ele.elements("leftblock")) {
            Element e = (Element)obj;
            this.cells.add(new LeftBlock(e));
        }
        this.name = ele.attributeValue("name");
        Element eHead = ele.element("head");
        if (eHead != null) {
            this.headCell = new Cell(eHead);
        }
    }

    public LeftBlock(int row, int column, int rowSpan, int columnSpan, String content) {
        super(row, column, rowSpan, columnSpan, content);
    }

    public void setRow(int row) {
        for (Cell cell : this.cells) {
            cell.row += row;
            if (!(cell instanceof LeftBlock)) continue;
            LeftBlock block = (LeftBlock)cell;
            block.setRow(row);
        }
        if (this.headCell != null) {
            this.headCell.row += row;
        }
    }

    @Override
    public void compile() {
        super.compile();
        if (this.headCell != null) {
            this.headCell.compile();
        }
    }

    @Override
    public void setReport(Report report) {
        super.setReport(report);
        if (this.headCell != null) {
            this.headCell.setReport(report);
        }
    }

    public int createCell(List<Cell> result) {
        this.cells.sort((o1, o2) -> o1.row * 10000 + o1.column - (o2.row * 10000 + o2.column));
        int copyRow = 0;
        for (Cell cell : this.cells) {
            if (cell instanceof LeftBlock) {
                LeftBlock block = (LeftBlock)cell;
                if (block.content != null && !block.content.trim().equals("")) {
                    int i = 0;
                    Object v = block.invoke();
                    if (!(v instanceof JSONArray)) {
                        throw new RuntimeException("\u5fc5\u987b\u8fd4\u56deJSONArray\uff0c\u884c\uff1a" + block.row + ", \u5217\uff1a" + block.column + ", \u5185\u5bb9\uff1a" + block.content);
                    }
                    JSONArray data = (JSONArray)v;
                    for (Object item : data) {
                        LeftBlock newBlock = block.clone();
                        if (i != 0) {
                            copyRow += block.rowSpan;
                        }
                        newBlock.setRow(copyRow);
                        ArrayList<Cell> cells = new ArrayList<Cell>();
                        newBlock.data = item;
                        this.report.vars.put(newBlock.name, item);
                        copyRow += newBlock.createCell(cells);
                        result.addAll(cells);
                        ++i;
                    }
                    continue;
                }
                LeftBlock newBlock = block.clone();
                newBlock.setRow(copyRow);
                ArrayList<Cell> cells = new ArrayList<Cell>();
                copyRow += newBlock.createCell(cells);
                result.addAll(cells);
                continue;
            }
            cell.row += copyRow;
            cell.content = cell.invoke().toString();
            result.add(cell);
        }
        if (this.headCell != null) {
            this.headCell.rowSpan += copyRow;
            this.headCell.content = this.headCell.invoke().toString();
            result.add(this.headCell);
        }
        return copyRow;
    }

    @Override
    public LeftBlock clone() {
        LeftBlock result = new LeftBlock(this.row, this.column, this.rowSpan, this.columnSpan, this.content);
        if (this.delegate != null) {
            result.delegate = this.delegate;
        }
        if (this.report != null) {
            result.report = this.report;
        }
        for (Cell cell : this.cells) {
            result.cells.add(cell.clone());
        }
        if (this.headCell != null) {
            result.headCell = this.headCell.clone();
        }
        if (this.name != null) {
            result.name = this.name;
        }
        return result;
    }
}

