/*
 * Decompiled with CFR 0.152.
 */
package com.aote.plugin;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NumberUtil {
    public static List<String> getNumberMark(String start, String count) {
        int s = Integer.parseInt(start);
        int c = Integer.parseInt(count);
        return NumberUtil.getNumberMark(s, c);
    }

    public static List<String> getNumberMark(int start, int count) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i <= count; ++i) {
            list.add(NumberUtil.getNumberFormat(start) + i);
        }
        return list;
    }

    public static String getNumberFormat(int num) {
        return String.format("%05d", num);
    }

    public static String seg(Object num) {
        if (num == null) {
            return "0";
        }
        String investPrice = NumberFormat.getCurrencyInstance().format(num);
        return investPrice.replace("\uffe5", "");
    }

    public static String isnull(Object num) {
        if (num == null) {
            return " ";
        }
        try {
            if (Double.parseDouble(num.toString()) == 0.0) {
                return " ";
            }
        }
        catch (Exception e) {
            return num.toString();
        }
        return num.toString();
    }

    public static String isnull(Object num, String flag) {
        if (num == null) {
            return " ";
        }
        if (flag == null || flag.trim().isEmpty()) {
            return num.toString();
        }
        Pattern pattern = Pattern.compile("[0-9]*\\.?[0-9]+");
        Matcher isNum1 = pattern.matcher(num.toString());
        Matcher isNum2 = pattern.matcher(flag);
        if (isNum1.matches() && isNum2.matches() && Double.parseDouble(flag) == Double.parseDouble(num.toString())) {
            return " ";
        }
        if (!isNum1.matches() && !isNum2.matches() && num.toString().equals(flag)) {
            return " ";
        }
        return num.toString();
    }

    public static String getNumFor(int x, Object num) {
        if (num == null) {
            return "0";
        }
        DecimalFormat df1 = (DecimalFormat)DecimalFormat.getInstance();
        df1.setGroupingSize(x);
        return df1.format(Long.valueOf(num.toString()));
    }

    public static String getPercent(int a, int b) {
        if (a == 0 || b == 0) {
            return "0.00%";
        }
        float num = (float)a / (float)b;
        DecimalFormat df = new DecimalFormat("0.00");
        String s = df.format(num);
        String ss = s.substring(2) + '%';
        return ss;
    }

    public static void main(String[] args) {
        System.out.println(NumberUtil.isnull("123.0", "123"));
    }
}

