SELECT
	nam,
	SUM (denglushichang)  AS denglushichang,
	SUM (zhimangshichang) AS zhimangshichang,
	SUM (zhimangcishu) AS zhimangcishu,
	SUM (weijie) AS weijie,
	SUM (yijie) AS yijie,
	SUM (weibo) AS weibo,
	SUM (jietingshichang) AS jietingshichang,
	SUM (threesjieting) AS threesjieting,
	SUM (quanbujieting) AS quanbujieting, 
	SUM (jieru) AS jieru,
	SUM (jiechu) AS jiechu,
	SUM (zixundan) AS zixundan,
	SUM (tousudan) AS tousudan,
	SUM (baoxiudan) AS baoxiudan
	
FROM
	(
		SELECT
			NAME AS nam,
			SUM (opspan) AS denglushichang,
			0 zhimangshichang,
			0 zhimangcishu,
			0 weijie,
			0 yijie,
			0 weibo,
			0 jietingshichang,
			0 threesjieting,
			0 quanbujieting,
			0 jieru,
			0 jiechu,
			0 zixundan,
			0 tousudan,
			0 baoxiudan
		FROM
			T_ATTENDANT_STATUS
		WHERE
			operation = '登入'
		AND TO_DATE (
			opstart,
			'yyyy-MM-dd hh24:mi:ss'
		) >= TO_DATE (
			'{startDate}',
			'yyyy-MM-dd hh24:mi:ss'
		)
		AND TO_DATE (
			opstart,
			'yyyy-MM-dd hh24:mi:ss'
		) <= TO_DATE (
			'{endDate}',
			'yyyy-MM-dd hh24:mi:ss'
		)
	GROUP BY
		NAME
	UNION ALL
		SELECT
			NAME AS nam,
			0 denglushichang,
			SUM (opspan) AS zhimangshichang,
			COUNT (*) AS zhimangcishu,
			0 weijie,
			0 yijie,
			0 weibo,
			0 jietingshichang,
			0 threesjieting,
			0 quanbujieting,
			0 jieru,
			0 jiechu,
			0 zixundan,
			0 tousudan,
			0 baoxiudan
		FROM
			T_ATTENDANT_STATUS
		WHERE
			operation = '置忙'
		AND TO_DATE (
			opstart,
			'yyyy-MM-dd hh24:mi:ss'
		) >= TO_DATE (
			'{startDate}',
			'yyyy-MM-dd hh24:mi:ss'
		)
		AND TO_DATE (
			opstart,
			'yyyy-MM-dd hh24:mi:ss'
		) <= TO_DATE (
			'{endDate}',
			'yyyy-MM-dd hh24:mi:ss'
		)
		
	GROUP BY
		NAME
	UNION ALL
		SELECT
			telname AS nam,
			0 denglushichang,
			0 zhimangshichang,
			0 zhimangcishu,
			COUNT (*) AS weijie,
			0 yijie,
			0 weibo,
			0 jietingshichang,
			0 threesjieting,
			0 quanbujieting,
			0 jieru,
			0 jiechu,
			0 zixundan,
			0 tousudan,
			0 baoxiudan
		FROM
			t_records
		WHERE
			starttime IS NULL
		AND TO_DATE (
			INLTIME,
			'yyyy-MM-dd hh24:mi:ss'
		) >= TO_DATE (
			'{startDate}',
			'yyyy-MM-dd hh24:mi:ss '
		)
		AND TO_DATE (
			INLTIME,
			'yyyy-MM-dd hh24:mi:ss'
		) <= TO_DATE (
			'{endDate}',
			'yyyy-MM-dd hh24:mi:ss'
		)
		
	GROUP BY
		telname
	UNION ALL
		SELECT
			telname AS nam,
			0 denglushichang,
			0 zhimangshichang,
			0 zhimangcishu,
			0 weijie,
			COUNT (*) AS yijie,
			0 weibo,
			0 jietingshichang,
			0 threesjieting,
			0 quanbujieting,
			0 jieru,
			0 jiechu,
			0 zixundan,
			0 tousudan,
			0 baoxiudan
		FROM
			t_records
		WHERE
			starttime IS NOT NULL
		AND endtime IS NOT NULL
		AND TO_DATE (
			INLTIME,
			'yyyy-MM-dd hh24:mi:ss'
		) >= TO_DATE (
			'{startDate}',
			'yyyy-MM-dd hh24:mi:ss '
		)
		AND TO_DATE (
			INLTIME,
			'yyyy-MM-dd hh24:mi:ss'
		) <= TO_DATE (
			'{endDate}',
			'yyyy-MM-dd hh24:mi:ss'
		)
		
	GROUP BY
		telname
	UNION ALL
		SELECT
			gonghao AS nam,
			0 denglushichang,
			0 zhimangshichang,
			0 zhimangcishu,
			0 weijie,
			0 yijie,
			COUNT (*) AS weibo,
			0 jietingshichang,
			0 threesjieting,
			0 quanbujieting,
			0 jieru,
			0 jiechu,
			0 zixundan,
			0 tousudan,
			0 baoxiudan
		FROM
			T_CALL_LOG
		WHERE
			islink = 'BZ_CALLOUT'
		AND TO_DATE (
			comingtime,
			'yyyy-MM-dd hh24:mi:ss'
		) >= TO_DATE (
			'{startDate}',
			'yyyy-MM-dd hh24:mi:ss '
		)
		AND TO_DATE (
			comingtime,
			'yyyy-MM-dd hh24:mi:ss'
		) <= TO_DATE (
			'{endDate}',
			'yyyy-MM-dd hh24:mi:ss'
		)
		
	GROUP BY
		gonghao
	UNION ALL
		SELECT
			telname AS nam,
			0 denglushichang,
			0 zhimangshichang,
			0 zhimangcishu,
			0 weijie,
			0 yijie,
			0 weibo,
			SUM (
				ROUND (
					TO_NUMBER (
						TO_DATE (
							endtime,
							'yyyy-MM-dd hh24:mi:ss'
						) - TO_DATE (
							starttime,
							'yyyy-MM-dd hh24:mi:ss'
						)
					) * 24*60
				)
			) AS jietingshichang,
			0 threesjieting,
			0 quanbujieting,
			0 jieru,
			0 jiechu,
			0 zixundan,
			0 tousudan,
			0 baoxiudan
		FROM
			t_records
		WHERE
			starttime IS NOT NULL
		AND endtime IS NOT NULL
		AND TO_DATE (
			INLTIME,
			'yyyy-MM-dd hh24:mi:ss'
		) >= TO_DATE (
			'{startDate}',
			'yyyy-MM-dd hh24:mi:ss'
		)
		AND TO_DATE (
			INLTIME,
			'yyyy-MM-dd hh24:mi:ss'
		) <= TO_DATE (
			'{endDate}',
			'yyyy-MM-dd hh24:mi:ss'
		)
		
	GROUP BY
		telname
	UNION ALL
		SELECT
			telname AS nam,
			0 denglushichang,
			0 zhimangshichang,
			0 zhimangcishu,
			0 weijie,
			0 yijie,
			0 weibo,
			0 jietingshichang,
			COUNT (*) AS threesjieting,
			0 quanbujieting,
			0 jieru,
			0 jiechu,
			0 zixundan,
			0 tousudan,
			0 baoxiudan
		FROM
			t_records
		WHERE
			starttime IS NOT NULL
		AND endtime IS NOT NULL
		AND ROUND (
			TO_NUMBER (
				TO_DATE (
					starttime,
					'yyyy-MM-dd hh24:mi:ss'
				) - TO_DATE (
					inltime,
					'yyyy-MM-dd hh24:mi:ss'
				)
			) * 24 * 60 * 60
		) < 3
		AND TO_DATE (
			INLTIME,
			'yyyy-MM-dd hh24:mi:ss'
		) >= TO_DATE (
			'{startDate}',
			'yyyy-MM-dd hh24:mi:ss '
		)
		AND TO_DATE (
			INLTIME,
			'yyyy-MM-dd hh24:mi:ss'
		) <= TO_DATE (
			'{endDate}',
			'yyyy-MM-dd hh24:mi:ss'
		)
		
	GROUP BY
		telname
	UNION ALL
		SELECT
			telname AS nam,
			0 denglushichang,
			0 zhimangshichang,
			0 zhimangcishu,
			0 weijie,
			0 yijie,
			0 weibo,
			0 jietingshichang,
			0 threesjieting,
			COUNT (*) AS quanbujieting,
			0 jieru,
			0 jiechu,
			0 zixundan,
			0 tousudan,
			0 baoxiudan
		FROM
			t_records
		WHERE
			starttime IS NOT NULL
		AND endtime IS NOT NULL
		AND TO_DATE (
			INLTIME,
			'yyyy-MM-dd hh24:mi:ss'
		) >= TO_DATE (
			'{startDate}',
			'yyyy-MM-dd hh24:mi:ss '
		)
		AND TO_DATE (
			INLTIME,
			'yyyy-MM-dd hh24:mi:ss'
		) <= TO_DATE (
			'{endDate}',
			'yyyy-MM-dd hh24:mi:ss'
		)
		
	GROUP BY
		telname
	UNION ALL
		SELECT
			telname AS nam,
			0 denglushichang,
			0 zhimangshichang,
			0 zhimangcishu,
			0 weijie,
			0 yijie,
			0 weibo,
			0 jietingshichang,
			0 threesjieting,
			0 quanbujieting,
			COUNT (*) AS jieru,
			0 jiechu,
			0 zixundan,
			0 tousudan,
			0 baoxiudan
		FROM
			t_records
		WHERE
			associatedid IS NOT NULL
		AND TO_DATE (
			INLTIME,
			'yyyy-MM-dd hh24:mi:ss'
		) >= TO_DATE (
			'{startDate}',
			'yyyy-MM-dd hh24:mi:ss '
		)
		AND TO_DATE (
			INLTIME,
			'yyyy-MM-dd hh24:mi:ss'
		) <= TO_DATE (
			'{endDate}',
			'yyyy-MM-dd hh24:mi:ss'
		)
		
	GROUP BY
		telname
	UNION ALL
		SELECT
			b.nam AS nam,
			0 denglushichang,
			0 zhimangshichang,
			0 zhimangcishu,
			0 weijie,
			0 yijie,
			0 weibo,
			0 jietingshichang,
			0 threesjieting,
			0 quanbujieting,
			0 jieru,
			COUNT (*) AS jiechu,
			0 zixundan,
			0 tousudan,
			0 baoxiudan
		FROM
			(
				SELECT
					telname AS nam,
					associatedid
				FROM
					t_records
				WHERE
					associatedid IS NOT NULL
				AND TO_DATE (
					INLTIME,
					'yyyy-MM-dd hh24:mi:ss'
				) >= TO_DATE (
					'{startDate}',
					'yyyy-MM-dd hh24:mi:ss '
				)
				AND TO_DATE (
					INLTIME,
					'yyyy-MM-dd hh24:mi:ss'
				) <= TO_DATE (
					'{endDate}',
					'yyyy-MM-dd hh24:mi:ss'
				)
			) b,
			(
				SELECT
					telname AS nam,
					ID
				FROM
					t_records
				WHERE
					associatedid IS NOT NULL
				AND TO_DATE (
					INLTIME,
					'yyyy-MM-dd hh24:mi:ss'
				) >= TO_DATE (
					'{startDate}',
					'yyyy-MM-dd hh24:mi:ss '
				)
				AND TO_DATE (
					INLTIME,
					'yyyy-MM-dd hh24:mi:ss'
				) <= TO_DATE (
					'{endDate}',
					'yyyy-MM-dd hh24:mi:ss'
				)
			) c
		WHERE
			b.associatedid = c. ID
		
	GROUP BY
		b.nam
	UNION ALL
		SELECT
			f_operator_name AS nam,
			0 denglushichang,
			0 zhimangshichang,
			0 zhimangcishu,
			0 weijie,
			0 yijie,
			0 weibo,
			0 jietingshichang,
			0 threesjieting,
			0 quanbujieting,
			0 jieru,
			0 jiechu,
			COUNT (*) zixundan,
			0 tousudan,
			0 baoxiudan
		FROM
			t_consult
		WHERE
			f_created_date>= TO_DATE (
				'{startDate}',
				'yyyy-MM-dd hh24:mi:ss '
			)
		AND f_created_date<= TO_DATE (
			'{endDate}',
			'yyyy-MM-dd hh24:mi:ss'
		)
		
	GROUP BY
		f_operator_name
	UNION ALL
		SELECT
			f_operator_name AS nam,
			0 denglushichang,
			0 zhimangshichang,
			0 zhimangcishu,
			0 weijie,
			0 yijie,
			0 weibo,
			0 jietingshichang,
			0 threesjieting,
			0 quanbujieting,
			0 jieru,
			0 jiechu,
			0 zixundan,
			COUNT (*) tousudan,
			0 baoxiudan
		FROM
			t_complaint
		WHERE f_created_date>= TO_DATE (
				'{startDate}',
				'yyyy-MM-dd hh24:mi:ss '
			)
		AND f_created_date<= TO_DATE (
			'{endDate}',
			'yyyy-MM-dd hh24:mi:ss'
		)
		
	GROUP BY
		f_operator_name
	UNION ALL
		SELECT
			f_attendant AS nam,
			0 denglushichang,
			0 zhimangshichang,
			0 zhimangcishu,
			0 weijie,
			0 yijie,
			0 weibo,
			0 jietingshichang,
			0 threesjieting,
			0 quanbujieting,
			0 jieru,
			0 jiechu,
			0 zixundan,
			0 tousudan,
			COUNT (*) baoxiudan
		FROM
			t_serviceworkorder
		WHERE
			
				f_created_date>= TO_DATE (
				'{startDate}',
				'yyyy-MM-dd hh24:mi:ss '
			)
		AND f_created_date<= TO_DATE (
			'{endDate}',
			'yyyy-MM-dd hh24:mi:ss'
		)
		AND f_workorder_type='报修单'
		
	GROUP BY
		f_attendant
	)
	where {
		operator != $$:
        $
        nam='{operator}'
        $,
        operator == $$:
        $
		1=1
        $,
        $$
 	   }
GROUP BY
	nam
ORDER BY
	nam