SELECT
	*
FROM
	(
		SELECT
			s.F_SERVICE_ID,
			s.f_workorder_type,
			s.F_CREATED_DATE,
			s.F_USER_NAME,
			s.F_CONTACT_PHONE,
			s.F_ADDRESS,
			w.f_date_leave,
			f_reason,
			de.failurerepair,
			c.f_content,
			s.id,
			s.f_processid,
			s.FAILURE
		FROM
			T_SERVICEWORKORDER s
		LEFT JOIN (
			SELECT
				F_SERVICE_ID,
				f_content
			FROM
				T_CONSULT
			UNION ALL
				SELECT
					F_SERVICE_ID,
					f_content
				FROM
					T_COMPLAINT
		) c ON c.F_SERVICE_ID = s.F_SERVICE_ID
		LEFT JOIN (
			SELECT
				ID,
				SERVICEID,
				f_date_leave
			FROM
				T_SERVICEWORK
			WHERE
				ID = ANY (
					SELECT
						MAX (ID)
					FROM
						T_SERVICEWORK
					GROUP BY
						serviceid
				)
		) w ON s. ID = w.SERVICEID
		LEFT JOIN (
			SELECT
				F_REASON_CHANGE || ',' || f_result_change f_reason,
				serviceid
			FROM
				t_doorrepair
			WHERE
				F_REASON_CHANGE IS NOT NULL
		) D ON D .serviceid = w. ID
		LEFT JOIN (
			SELECT
				SID,
				listagg (
					f_content || '' || f_contentmessage || ';' || ' ',
					''
				) WITHIN GROUP (ORDER BY SID) failurerepair
			FROM
				(
					SELECT
						s.serviceid SID,
						s.f_type TYPE,
						D .*
					FROM
						t_details D
					LEFT JOIN t_servicerepair s ON D .f_service_id = s. ID
				) s
			GROUP BY
				SID
		) de ON de. SID = w. ID
	)
WHERE
	f_service_id IS NOT NULL
	 AND {condition}
ORDER BY
	F_CREATED_DATE