// 话务员当日统计信息，传入userid即可
// 统计保修单，资询单，投诉单，BZ_CALLIN（呼入），BZ_CALLOUT（呼出）
select cnt, aType, attendant from (
	SELECT
		COUNT(*) AS cnt,
		f_workorder_type AS aType,
		f_attendant as attendant
	FROM
		T_SERVICEWORKORDER
	WHERE 
	{
		userid != $$ : 
		$ f_attendant = '{userid}' $,
		$ 1=1 $
	}
	AND SUBSTR (TO_CHAR (f_created_date, 'yyyy-mm-dd hh24:mi:ss'), 0, 19) >= '{startTime}' 
	AND SUBSTR (TO_CHAR (f_created_date, 'yyyy-mm-dd hh24:mi:ss'), 0, 19) <= '{endTime}' 
	GROUP BY
		f_attendant, f_workorder_type
	
UNION

	SELECT
		COUNT(*) as cnt,
		cast('呼出' as varchar2(50)) as aType,
		gonghao as attendant
	FROM
		T_CALL_LOG
	WHERE
	{
		userid != $$ : 
		$ gonghao = '{userid}' $,
		$ 1=1 $
	}
	 and islink = 'BZ_CALLOUT'
	AND HANDUPTIME >= '{startTime}'
	AND HANDUPTIME <= '{endTime}'
	GROUP BY
		gonghao

UNION 
	select count(*) as cnt,
	cast('呼入' as varchar2(50)) as aType,
	telname as attendant
	from t_records
	where 
	{
		userid != $$ : 
		$ telname = '{userid}' $,
		$ 1=1 $
	}
	AND SUBSTR (savetime, 0, 19) >= '{startTime}'
	AND SUBSTR (savetime, 0, 19) <= '{endTime}'
	GROUP BY
		telname
) t
order by attendant, aType
	