import Vue from 'vue'
import App from './App'
import { all } from 'vue-client'

Vue.config.silent = false

all()
require('./bootstrap/less/bootstrap.less')

/** ********************** pc端 *********************** **/
// 文字客服界面
Vue.component('text-server', (resolve) => { require(['./components/pc/TextServer'], resolve) })
// 语音客服界面
Vue.component('voice-server', (resolve) => { require(['./components/pc/VoiceServer'], resolve) })
// 辅助功能，包含停气公告和知识库，都支持拖拽功能
Vue.component('auxfunc', (resolve) => { require(['./components/pc/Auxfunc'], resolve) })
// 话务员控制台（主要是话务员相关的所有操作按钮）
Vue.component('console', (resolve) => { require(['./components/pc/console'], resolve) })
// 用户历史操作信息，包含历史通话，历史抄表，购气记录，历史安检
Vue.component('past-info', (resolve) => { require(['./components/pc/PastInfo'], resolve) })
// 话务员信息，包含话务统计，坐席人员统计，文字客服统计（这三项只针对班长显示）
Vue.component('tele-info', (resolve) => { require(['./components/pc/TeleInfo'], resolve) })
// 地图，话务员查看用户，维修人员的地理位置
Vue.component('tele-map', (resolve) => { require(['./components/pc/TeleMap'], resolve) })
// 文字客服，与微信进行私人客服，其中包含，图片，语音，视频等发送接收的功能
Vue.component('text-service', (resolve) => { require(['./components/pc/TextService'], resolve) })
// 文字客服消息（综合左右测消息）
Vue.component('chat-msg', (resolve) => { require(['./components/pc/ChatMsg'], resolve) })
// 用户基本信息
Vue.component('userinfo-pover', (resolve) => { require(['./components/pc/UserinfoPover'], resolve) })
// 用户操作，包含手动查询用户，自动查询用户，派单功能
Vue.component('user-operate', (resolve) => { require(['./components/pc/UserOperate'], resolve) })
// 工单派发
Vue.component('distribute-work', (resolve) => { require(['./components/pc/DistributeWork'], resolve) })
// 咨询单
Vue.component('seek-work', (resolve) => { require(['./components/pc/SeekWork'], resolve) })
// 投诉单
Vue.component('complain-work', (resolve) => { require(['./components/pc/ComplainWork'], resolve) })
// 报修单
Vue.component('repairs-work', (resolve) => { require(['./components/pc/RepairsWork'], resolve) })
// 查找用户，当不能自动查找到用户时，需要话务员手动查找到用户
Vue.component('find-user', (resolve) => { require(['./components/pc/FindUser'], resolve) })
// 站点工单，包含工单查询列表，单个工单历史记录
Vue.component('stand-work', (resolve) => { require(['./components/pc/StandWork'], resolve) })
// 工单查询列表
Vue.component('work-list', (resolve) => { require(['./components/pc/WorkList'], resolve) })
// 工单历史信息
Vue.component('repair-history-list', (resolve) => { require(['./components/pc/RepairHistoryList'], resolve) })
// 话务员整体统计
Vue.component('telephonist-msg', (resolve) => { require(['./components/pc/TelephonistMsg'], resolve) })
// 单个话务员信息（显示）
Vue.component('operator-information', (resolve) => { require(['./components/pc/OperatorInformation'], resolve) })
// 话务员工单消息
Vue.component('work-msg', (resolve) => { require(['./components/pc/WorkMsg'], resolve) })

// 班组长界面 包括 话务统计 做席人员统计 文字客服统计 单个话务员信息 工单查询 5个组建
Vue.component('monitor-group', (resolve) => { require(['./components/pc/MonitorGroup'], resolve) })
// 话务统计
Vue.component('telephonist-count', (resolve) => { require(['./components/pc/TelephonistCount'], resolve) })
// 做席人员统计
Vue.component('personnel-count', (resolve) => { require(['./components/pc/PersonnelCount'], resolve) })
// 文字客服统计
Vue.component('text-count', (resolve) => { require(['./components/pc/TextCount'], resolve) })
// 单个话务员信息
Vue.component('tele-list', (resolve) => { require(['./components/pc/TeleList'], resolve) })
// 工单查询
Vue.component('work-find', (resolve) => { require(['./components/pc/WorkFind'], resolve) })
// 工单历史记录
Vue.component('work-history', (resolve) => { require(['./components/pc/WorkHistory'], resolve) })
// 文字聊天记录查询
Vue.component('query-text-history', (resolve) => { require(['./components/pc/QueryTextHistory'], resolve) })
// 语音记录查询
Vue.component('query-tele-history', (resolve) => { require(['./components/pc/QueryTeleHistory'], resolve) })
// pc端微信相关组件
// 自定义菜单界面
Vue.component('custom-menu', (resolve) => { require(['./components/pc/wx/CustomMenu'], resolve) })
// 自定义菜单手机界面
Vue.component('mobile-view', (resolve) => { require(['./components/pc/wx/MobileView'], resolve) })
// 自定义菜单手机界面
Vue.component('menu-view', (resolve) => { require(['./components/pc/wx/MenuView'], resolve) })
// 微信素材列表
Vue.component('select-material', (resolve) => { require(['./components/pc/wx/SelectMaterial'], resolve) })
// 微信素材列表
Vue.component('news-material', (resolve) => { require(['./components/pc/wx/NewsMaterial'], resolve) })
// 停气管理
Vue.component('stop-gas-manager', (resolve) => { require(['./components/pc/dataManager/StopGasManager'], resolve) })
// 表情选择
Vue.component('emoji', (resolve) => { require(['./components/pc/Emoji'], resolve) })
/** 参数管理页面 **/
// 素材页面，包含使用与管理，管理页面要发送素材到服务器和为微信素材库
Vue.component('materials', (resolve) => { require(['./components/pc/dataManager/Materials'], resolve) })
// 营业厅网点管理
Vue.component('outlets-manager', (resolve) => { require(['./components/pc/dataManager/OutletsManager'], resolve) })
// 安全知识库管理
Vue.component('safety-manager', (resolve) => { require(['./components/pc/dataManager/SafetyManager'], resolve) })

/** ********************** 工单组件，一下组件为三端兼容组件 *********************** **/
// 报警器维修
Vue.component('alarm-maintenance', (resolve) => { require(['./components/workorder/AlarmMaintenance'], resolve) })
// 热水器维修
Vue.component('water-maintenance', (resolve) => { require(['./components/workorder/WaterMaintenance'], resolve) })
// 管道维修
Vue.component('pipeline-maintenance', (resolve) => { require(['./components/workorder/PipelineMaintenance'], resolve) })
// 事故处理
Vue.component('accident-treatment', (resolve) => { require(['./components/workorder/AccidentTreatment'], resolve) })
// 所有维修公用项
Vue.component('repair-public', (resolve) => { require(['./components/workorder/RepairPublic'], resolve) })
// 卡表维修
Vue.component('card-repair', (resolve) => { require(['./components/workorder/CardRepair'], resolve) })
// 灶具维修
Vue.component('cook-repair', (resolve) => { require(['./components/workorder/CookRepair'], resolve) })
// 挂壁炉维修
Vue.component('fireplace-repair', (resolve) => { require(['./components/workorder/FireplaceRepair'], resolve) })
// 抽油烟机维修
Vue.component('smoke-repair', (resolve) => { require(['./components/workorder/SmokeRepair'], resolve) })
// 用户基本信息
Vue.component('repair-user-info', (resolve) => { require(['./components/workorder/RepairUserInfo'], resolve) })
// 通用头部组件，包含返回及其他扩展(为app端东西，在pc端不显示，单需要注册，负责pc端报错)
Vue.component('app-header', (resolve) => { require(['./components/android/AppHeader'], resolve) })
// pc端大组件
Vue.component('repair-order', (resolve) => { require(['./components/workorder/RepairOrder'], resolve) })
// 户内维修
Vue.component('door-service', (resolve) => { require(['./components/workorder/DoorService'], resolve) })
// 管道
Vue.component('pipeline', (resolve) => { require(['./components/workorder/Pipeline'], resolve) })
// 设备维修
Vue.component('device-service', (resolve) => { require(['./components/workorder/DeviceService'], resolve) })
// 灶具维修
Vue.component('cooking-utensils', (resolve) => { require(['./components/workorder/CookingUtensils'], resolve) })
// 事故处理
Vue.component('trouble-removal', (resolve) => { require(['./components/workorder/TroubleRemoval'], resolve) })
// 故障汇总
Vue.component('fault-all', (resolve) => { require(['./components/workorder/FaultAll'], resolve) })

// 报修
Vue.component('repairs-tell', (resolve) => { require(['./components/workorder/RepairsTell'], resolve) })
// // 维修
Vue.component('repairs-service', (resolve) => { require(['./components/workorder/RepairsService'], resolve) })
// // 回访
Vue.component('visit', (resolve) => { require(['./components/workorder/Visit'], resolve) })

// 临时组件，产品已经有，向产品融合时删除
// 参数管理组件（3个）
Vue.component('param-manage', (resolve) => { require(['./components/temp/ParamManager/ParamManage'], resolve) })
Vue.component('param-page', (resolve) => { require(['./components/temp/ParamManager/ParamPage'], resolve) })
Vue.component('single-page', (resolve) => { require(['./components/temp/ParamManager/SinglePage'], resolve) })
// 历史列表(临时组件)
Vue.component('card-list', (resolve) => { require(['./components/temp/rightview/CardList'], resolve) })
// 发卡售气详情小组件
Vue.component('salecardgas-detail', (resolve) => { require(['./components/temp/rightview/carddetail/SalecardgasDetail'], resolve) })
// 卡表收费详情小组件
Vue.component('cardmetercenter-detail', (resolve) => { require(['./components/temp/rightview/carddetail/CardMeterCenterDetail'], resolve) })
// 卡表超用详情小组件
Vue.component('cardoveruser-detail', (resolve) => { require(['./components/temp/rightview/carddetail/CardOverUserDetail'], resolve) })
// 机表收费详情小组件
Vue.component('machinemetercenter-detail', (resolve) => { require(['./components/temp/rightview/carddetail/MachineMeterCenterDetail'], resolve) })
// 自动下账详情小组件
Vue.component('autoaccounts-detail', (resolve) => { require(['./components/temp/rightview/carddetail/AutoAccountsDetail'], resolve) })
// 自动下账详情小组件
Vue.component('bankdk-detail', (resolve) => { require(['./components/temp/rightview/carddetail/BankDKDetail'], resolve) })
// 自动下账详情小组件
Vue.component('bank-pay', (resolve) => { require(['./components/temp/rightview/carddetail/BankPay'], resolve) })
// 自动下账详情小组件
Vue.component('wechat-pay', (resolve) => { require(['./components/temp/rightview/carddetail/WeChatPay'], resolve) })
// 超用收费详情小组件
Vue.component('overuserchange-detail', (resolve) => { require(['./components/temp/rightview/carddetail/OverUserChangeDetail'], resolve) })
// 表具停用详情小组件
Vue.component('disablemanage-detail', (resolve) => { require(['./components/temp/rightview/carddetail/DisableManageDetail'], resolve) })
// 表具启用详情小组件
Vue.component('enablemanage-detail', (resolve) => { require(['./components/temp/rightview/carddetail/EnableManageDetail'], resolve) })
// 补卡管理详情小组件
Vue.component('replacecardmanage-detail', (resolve) => { require(['./components/temp/rightview/carddetail/ReplaceCardManageDetail'], resolve) })
// 补气情小组件
Vue.component('offgasaddgas-detail', (resolve) => { require(['./components/temp/rightview/carddetail/OffGasAddGasDetail'], resolve) })
// 过户管理详情小组件
Vue.component('transfermanage-detail', (resolve) => { require(['./components/temp/rightview/carddetail/TransferManageDetail'], resolve) })
// 其他收费详情小组件
Vue.component('othercharge-detail', (resolve) => { require(['./components/temp/rightview/carddetail/OtherChargeDetail'], resolve) })
// 抄表员变更详情小组件
Vue.component('inputtorchange-detail', (resolve) => { require(['./components/temp/rightview/carddetail/InputtorChangeDetail'], resolve) })
// 气价变更详情小组件
Vue.component('gaspricechange-detail', (resolve) => { require(['./components/temp/rightview/carddetail/GasPriceChangeDetail'], resolve) })
// 新增户档案详情小组件
Vue.component('adduser-detail', (resolve) => { require(['./components/temp/rightview/carddetail/AddUserDetail'], resolve) })
// 档案变更详情小组件
Vue.component('userchange-detail', (resolve) => { require(['./components/temp/rightview/carddetail/UserChangeDetail'], resolve) })
// 换表管理详情小组件
Vue.component('changemeter-detail', (resolve) => { require(['./components/temp/rightview/carddetail/ChangeMeterDetail'], resolve) })
// 销户详情小组件
Vue.component('cancellation-detail', (resolve) => { require(['./components/temp/rightview/carddetail/CancellationDetail'], resolve) })
// 用户退费详情小组件
Vue.component('refund-detail', (resolve) => { require(['./components/temp/rightview/carddetail/RefundDetail'], resolve) })
// 用户基本信息
Vue.component('userinfo', (resolve) => { require(['./components/temp/Userinfo'], resolve) })
// 用户基本信息
Vue.component('main', (resolve) => { require(['./components/temp/Main'], resolve) })
// 登录
Vue.component('login', (resolve) => { require(['./components/temp/server/Login'], resolve) })
// 左侧树菜单
Vue.component('left-tree', (resolve) => { require(['./components/temp/server/LeftTree'], resolve) })
// 左图标菜单
Vue.component('icon-tree', (resolve) => { require(['./components/temp/server/IconTree'], resolve) })
// 添加变更记录
Vue.component('add-change-msg', (resolve) => { require(['./components/temp/server/AddChangeMsg'], resolve) })
// 变更展示
Vue.component('change-declare', (resolve) => { require(['./components/temp/server/ChangeDeclare'], resolve) })
// 身份验证
Vue.component('id-verify', (resolve) => { require(['./components/temp/server/IdVerify'], resolve) })
// 加载参数
Vue.component('load-data', (resolve) => { require(['./components/temp/server/LoadData'], resolve) })
// 修改密码
Vue.component('modify-pw', (resolve) => { require(['./components/temp/server/ModifyPw'], resolve) })

/* eslint-disable no-new */
new Vue({
  el: 'body',
  components: { App }
})
