/*
 * Decompiled with CFR 0.152.
 */
package com.aote.job;

import java.io.IOException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class PatrolFormJob {
    private static Logger log = Logger.getLogger(PatrolFormJob.class);
    private HashMap<String, String> map;
    private String logic;
    private String patrolUrl;
    private String ccurl;

    public void run() throws Exception {
        String lastFormFoundTime = this.findLastFormFoundTime();
        JSONArray rows = this.fetchPatrolFormByTimestamp(lastFormFoundTime);
        if (rows.length() > 0) {
            log.debug((Object)("\u63d0\u53d6\u5230\u6570\u636e\u6761\u6570:" + rows.length()));
            this.normalize(rows);
            for (int i = 0; i < rows.length(); ++i) {
                this.runlogic(rows.getJSONObject(i));
            }
            this.updateParam();
        }
    }

    private void updateParam() throws Exception {
        String path = this.ccurl + "rs/logic/update";
        String body = "{data: {tablename:\"t_singlevalue\", condition: \" name='patrolTimestamp'\", parameters: {value: \"" + this.standardDatetime() + "\"}}}";
        HttpPost postMethod = new HttpPost(path);
        StringEntity se = new StringEntity(body, "UTF-8");
        postMethod.setEntity((HttpEntity)se);
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpResponse response = httpClient.execute((HttpUriRequest)postMethod);
        int code = response.getStatusLine().getStatusCode();
        if (code != 200) {
            throw new RuntimeException("\u8fd4\u56de\u503c\u9519\u8bef\uff1a" + code + "\npath: " + path + "\nbody:" + body);
        }
    }

    private void runlogic(JSONObject row) throws Exception {
        String path = this.ccurl + "rs/logic/" + this.logic;
        String body = "{\"data\":" + row + "}";
        HttpPost postMethod = new HttpPost(path);
        StringEntity se = new StringEntity(body, "UTF-8");
        postMethod.setEntity((HttpEntity)se);
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpResponse response = httpClient.execute((HttpUriRequest)postMethod);
        int code = response.getStatusLine().getStatusCode();
        if (code != 200) {
            throw new RuntimeException("\u8fd4\u56de\u503c\u9519\u8bef\uff1a" + code + "\npath: " + path + "\nbody:" + body);
        }
    }

    private String standardDatetime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date());
    }

    private void normalize(JSONArray rows) {
        for (int i = 0; i < rows.length(); ++i) {
            String[] keys;
            JSONObject unknwn = rows.getJSONObject(i);
            Set set = unknwn.keySet();
            for (String key : keys = set.toArray(new String[0])) {
                if (!this.map.containsKey(key)) continue;
                String value = unknwn.getString(key);
                unknwn.remove(key);
                unknwn.put(this.map.get(key), (Object)value);
            }
        }
    }

    private JSONArray fetchPatrolFormByTimestamp(String ts) throws ParseException, IOException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpGet httpGet = new HttpGet(this.patrolUrl + URLEncoder.encode(ts).replace("+", "%20"));
        HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IOException();
        }
        String xml = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
        xml = xml.substring(xml.indexOf("\">", 0) + 2);
        xml = xml.substring(0, xml.indexOf("</string>")).trim();
        return new JSONArray(xml);
    }

    private String findLastFormFoundTime() throws Exception {
        String path = this.ccurl + "rs/sql/singleTable";
        String body = "{data: {tablename:\"t_singlevalue\", condition: \" name='patrolTimestamp'\"}}";
        HttpPost postMethod = new HttpPost(path);
        StringEntity se = new StringEntity(body, "UTF-8");
        postMethod.setEntity((HttpEntity)se);
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpResponse response = httpClient.execute((HttpUriRequest)postMethod);
        int code = response.getStatusLine().getStatusCode();
        if (code == 200) {
            String actual = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
            JSONArray rows = new JSONArray(actual);
            return rows.getJSONObject(0).getString("value");
        }
        throw new RuntimeException("\u8fd4\u56de\u503c\u9519\u8bef\uff1a" + code + "\npath: " + path + "\nbody:" + body);
    }

    public String getLogic() {
        return this.logic;
    }

    public void setLogic(String logic) {
        this.logic = logic;
    }

    public String getPatrolUrl() {
        return this.patrolUrl;
    }

    public void setPatrolUrl(String patrolUrl) {
        this.patrolUrl = patrolUrl;
    }

    public String getCcurl() {
        return this.ccurl;
    }

    public void setCcurl(String ccurl) {
        this.ccurl = ccurl;
    }

    public HashMap<String, String> getMap() {
        return this.map;
    }

    public void setMap(HashMap<String, String> map) {
        this.map = map;
    }
}

