
package com.aote.plugin;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.hibernate.SQLQuery;
import org.hibernate.Session;

import com.aote.sql.SqlServer;

public class ServiceNoGenerator {

	public String getNo(SqlServer sql, String type) throws Exception {
		String code = "BX";
		if (type.equals("民用"))
			code += "R";
		else if(type.equals("巡检"))
			code = "XJD";
		else
			code += "C";
		Date dt = new Date();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
		code += sdf.format(dt);
		Session session = sql.getSessionFactory().getCurrentSession();
		SQLQuery sq = session
				.createSQLQuery("select max(s)c from (select SUBSTR(f_service_id,12,4)s  from T_SERVICEWORKORDER WHERE F_SERVICE_ID like:id )");
		// 保证取到的单号连续
		synchronized (ServiceNoGenerator.class) {
			Object obj = sq.addScalar("c").setParameter("id", code + "%")
					.uniqueResult();
			code += String.format("%4s", (((BigDecimal) obj).intValue() + 1) + "")
					.replace(" ", "0");
		}
		return code;
	}
}
