package com.aote.plugin;

import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HTTP;
import org.json.JSONObject;


public class PatrolFeedback {

	/**
	 * 
	 * @param url  http://192.168.2.63/JJGIS_JK/LPResource/LPService/HiddenJK.asmx/AddHiddenInfo
	 * @param f_patrol_id  原始巡检单id
	 * @param f_order_man  维修员
	 * @param f_result     结单结论
	 * @param f_settle_time 结单时间
	 * @throws Exception
	 */
	public boolean feedback(String url, String f_patrol_id, String f_order_man, String f_result, String f_settle_time) throws Exception {
		//HPP_GUID，USERNAME，PROCESSDATE，SUGGESTION
		JSONObject jo = new JSONObject();
		jo.put("HPP_GUID", f_patrol_id);
		jo.put("USERNAME", f_order_man);
		jo.put("PROCESSDATE", f_settle_time);
		jo.put("SUGGESTION", f_result);
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader(HTTP.CONTENT_TYPE, "application/x-www-form-urlencoded;charset=UTF-8");
        List<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("dataHtJson", jo.toString()));
        httpPost.setEntity(new UrlEncodedFormEntity(nameValuePairs, "UTF-8"));
        HttpClient httpClient = new DefaultHttpClient();
        HttpResponse response = httpClient.execute(httpPost);
        return response.getStatusLine().getStatusCode() == 200; 
	}
}
