package com.aote.plugin;

import java.text.SimpleDateFormat;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

/**
 * 计算坐席操作统计，
 * 接听秒数
 * 通话秒数
 * 保存秒数
 * @author LGY
 *
 */
public class AttendantOpInSeconds {

	public JSONArray stat(JSONObject call) throws Exception {
	    JSONArray rows = new JSONArray();
	    String callId = call.getString("id");
	    String inline = call.getString("inline");
	    
	    if(call.isNull("telname"))
	    	return rows;
	    String name = call.getString("telname");
	    
	    if(call.isNull("inltime"))
	    	return rows;
	    
		String alertTime = call.getString("inltime");
		// attendant failed to pick it up either because customer hanged it up or because attendant refused
		if(call.isNull("starttime") && !call.isNull("endtime"))
			call.put("starttime", call.getString("endtime"));
		
		if(call.isNull("starttime"))
			return rows;
		
		// 接听时间
		String pickupTime = call.getString("starttime");
		JSONObject row = new JSONObject();
		row.put("id", UUID.randomUUID().toString());
		row.put("name", name);
		row.put("module", 2);
		row.put("channel", inline);
		row.put("callid", callId);
		row.put("operation", "接听");
		row.put("opstart", alertTime);
		row.put("opend", pickupTime);
		row.put("opspan", getTimeDiffInSeconds(pickupTime, alertTime));
		rows.put(row);
		
		// 通话时间
		if(call.isNull("endtime"))
			return rows;
		String hangupTime = call.getString("endtime");
		row = new JSONObject();
		row.put("id", UUID.randomUUID().toString());
		row.put("name", name);
		row.put("module", 2);
		row.put("channel", inline);
		row.put("callid", callId);
		row.put("operation", "通话");
		row.put("opstart", pickupTime);
		row.put("opend", hangupTime);
		row.put("opspan", getTimeDiffInSeconds(hangupTime, pickupTime));
		rows.put(row);
		
		// 保存时间
		if(call.isNull("savetime"))
			return rows;
		String saveFormTime = call.getString("savetime");
		row = new JSONObject();
		row.put("id", UUID.randomUUID().toString());
		row.put("name", name);
		row.put("module", 2);
		row.put("channel", inline);
		row.put("callid", callId);
		row.put("operation", "保存");
		row.put("opstart", hangupTime);
		row.put("opend", saveFormTime);
		row.put("opspan", getTimeDiffInSeconds(saveFormTime, hangupTime));
		rows.put(row);
		
		return rows;
	}

	private long getTimeDiffInSeconds(String timeEnd, String timeStart) throws Exception{
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		return (sdf.parse(timeEnd).getTime() - sdf.parse(timeStart).getTime()) / 1000;
	}
}
