package com.aote.rs;

import com.aote.logic.LogicServer;
import com.aote.sql.SqlServer;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * 根据gis编号生成停复气计划
 */
@Path("FindRegulator")
@Component
@Transactional
public class FindRegulator {
    static Logger log = Logger.getLogger(FindRegulator.class);
    @Autowired
    private SqlServer sqlServer;
    @Autowired
    private LogicServer logicServer;


    @POST
    public String create(String str) {
//        String [] a = {"TYSB911", "TYSB913",
//                "TYSB3394",
//                "TYSB1975",
//                "TYSB3976",
//                "TYSB1971",
//                "TYSB99",
//                "TYSB3229",
//                "TYSB701",
//                "TYSB705",
//                "TYSB2777",
//                "TYSB3417",
//                "TYSB1970",
//                "TYSB907",
//                "TYSB2794",
//                "TYSB100",
//                "TYSB2690",
//                "TYSB3744",
//                "TYSB2764",
//                "TYSB2759",
//                "TYSB2781",
//                "TYSB178",
//                "TYSB2789",
//                "TYSB3974",
//                "TYSB920",
//                "TYSB1972",
//                "TYSB2778",
//                "TYSB1969",
//                "TYSB2780",
//                "TYSB101",
//                "TYSB703",
//                "TYSB2689",
//                "TYSB909",
//                "TYSB918",
//                "TYSB912",
//                "TYSB917",
//                "TYSB910",
//                "TYSB3410",
//                "TYSB905" };
//        JSONArray jsonArray = null;
//        try {
//            jsonArray = sqlServer.query("select id from t_regulator_files where rownum<40");
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//        int n = 0;
//        for(int i=0;i<jsonArray.length();i++){
//            for(int j = n;j<a.length;){
//                log.debug("i"+i);
//                log.debug("j"+j);
//                JSONObject json = jsonArray.getJSONObject(i);
//                sqlServer.run("update t_regulator_files set f_gis_id = '" + a[j] + "' where id = '" + json.getString("id") + "'");
//                break;
//            }
//            n= n+1;
//        }



        log.debug("根据gis编号查询档案=====>"+str);
        JSONObject result = new JSONObject();
        try {
            String [] arr = str.split(",");
            JSONArray items = new JSONArray();
            int count = 0;
            for (String anArr : arr) {
                log.debug("anArr"+anArr);
                JSONArray jsonArray = sqlServer.query("select f_user_unit,f_gis_id,f_gas_supply_load,f_user_type from t_regulator_files where f_gis_id = '" + anArr +"'");
                if(jsonArray.length()>0){
                    JSONObject json = jsonArray.getJSONObject(0);
                    String supply_load = json.getString("f_gas_supply_load");
                    count = count + Integer.parseInt(supply_load.substring(0,supply_load.length()-1));
                    items.put(json);
                }
            }
            result.put("state","success");
            result.put("result",items);
            result.put("civilCount",count);
            return result.toString();
        }catch (Exception e) {
            e.printStackTrace();
            result.put("state","fail");
            result.put("result",new JSONArray());
            return result.toString();
        }

    }

}
