/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.rs.LogicService;
import com.aote.rs.SqlService;
import com.aote.sql.SqlMapper;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="ReadMeterBusiness")
@Component
public class ReadMeterBatchBusinessService {
    private static final Logger LOGGER = Logger.getLogger(ReadMeterBatchBusinessService.class);
    @Autowired
    private SqlService sqlService;
    @Autowired
    private LogicService logicService;
    private static final Integer processors = Runtime.getRuntime().availableProcessors();
    private static final ExecutorService executorService = Executors.newFixedThreadPool(processors + 1);

    @POST
    @Path(value="batchRun/{logicName}")
    public Response batchRunByResult(@PathParam(value="logicName") String logicName, String values, @Context HttpServletRequest request) {
        JSONObject params = new JSONObject(values);
        JSONArray sqlResult = params.getJSONArray("params");
        this.doBusinessBySqlResult(logicName, values, sqlResult, request);
        return Response.ok().build();
    }

    @POST
    @Path(value="batchRun/{logicName}/{sqlName}")
    public Response batchRunByName(@PathParam(value="logicName") String logicName, @PathParam(value="sqlName") String sqlName, String values, @Context HttpServletRequest request) {
        JSONObject params = new JSONObject(values);
        String logicParams = String.valueOf(params.get("logicParams"));
        String sqlParams = String.valueOf(params.get("sqlParams"));
        this.doBusinessBySqlName(logicName, logicParams, sqlName, sqlParams, request);
        return Response.ok().build();
    }

    private void doBusinessBySqlResult(String logicName, String values, JSONArray sqlResult, HttpServletRequest request) {
        this.doBusiness(logicName, values, sqlResult, null, null, request);
    }

    private void doBusinessBySqlName(String logicName, String values, String sqlName, String sqlParams, HttpServletRequest request) {
        this.doBusiness(logicName, values, null, sqlName, sqlParams, request);
    }

    private void doBusiness(String logicName, String values, JSONArray sqlResult, String sqlName, String sqlParams, HttpServletRequest request) {
        JSONObject data = new JSONObject(values);
        LOGGER.info((Object)("======\u5f00\u59cb\u6267\u884c\u6279\u91cf[" + logicName + "]\u4e1a\u52a1\u6d41\u7a0b======"));
        JSONArray resultArray = sqlName != null ? this.getSqlResult(sqlName, sqlParams) : sqlResult;
        if (resultArray != null && resultArray.length() > 0) {
            JSONObject countData = new JSONObject();
            countData.put("total", resultArray.length());
            countData.put("index", 1);
            countData.put("errorCount", 0);
            AtomicInteger ai = new AtomicInteger(1);
            resultArray.forEach(item -> executorService.execute(() -> {
                try {
                    data.put("object", item);
                    this.runLogic(logicName, data.getJSONObject("object"), request, countData);
                    LOGGER.info((Object)("======\u4e1a\u52a1\u6d41\u7a0b[" + logicName + "]\u6279\u91cf\u6267\u884c\u4e2d\uff1a\u603b\u6570\uff1a" + countData.getInt("total") + ", \u5f53\u524d\uff1a" + ai.getAndIncrement() + "======="));
                }
                catch (Exception e) {
                    LOGGER.error((Object)e);
                }
            }));
            LOGGER.info((Object)("======\u4e1a\u52a1\u6d41\u7a0b[" + logicName + "]\u6279\u91cf\u6267\u884c\u7ed3\u675f\uff0c\u9519\u8bef\u6570\uff1a" + countData.getInt("errorCount") + "======="));
        } else {
            LOGGER.info((Object)("======\u4e1a\u52a1\u6d41\u7a0b[" + logicName + "]\u6279\u91cf\u6267\u884c\u672a\u6267\u884c\uff1a\u6ca1\u6709\u9700\u8981\u8f6e\u8be2\u7684\u6570\u636e"));
        }
    }

    private JSONArray getSqlResult(String sqlName, String sqlData) {
        if (SqlMapper.getSql((String)sqlName) == null) {
            LOGGER.info((Object)("\u672a\u627e\u5230\u540d\u4e3a\u3010" + sqlName + "\u3011\u7684SQL\u6620\u5c04\u6587\u4ef6"));
            return null;
        }
        try {
            JSONObject params = new JSONObject();
            params.put("data", (Object)sqlData);
            return new JSONArray(this.sqlService.txExecute(sqlName, 1, 9999999, params.toString()));
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
            return null;
        }
    }

    private void runLogic(String logicName, JSONObject data, HttpServletRequest request, JSONObject countData) {
        try {
            this.logicService.xtSave(logicName, data.toString(), request);
        }
        catch (Exception e) {
            int errorCount = countData.getInt("errorCount") + 1;
            countData.put("errorCount", errorCount);
        }
    }
}

