package com.aote.rs;

import com.af.plugins.CommonTools;
import com.af.plugins.JsonTools;
import com.af.plugins.RestTools;
import org.json.JSONObject;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ImageUpload {
    private static Logger log = Logger.getLogger(MobileServicePlugin.class);
    public static String getImageText(JSONObject jsonObject){
        log.debug("getImageText:"+jsonObject);
        ImageData imageData=new ImageData();
        String fileName=jsonObject.getString("fileName");
        String width=jsonObject.getString("width");
        String height=jsonObject.getString("height");
        String imData=jsonObject.getString("imData");
        String imageType=jsonObject.getString("imageType");
        imageData.setName(fileName);
        imageData.setWidth(Integer.parseInt(width));
        imageData.setHeight(Integer.parseInt(height));
        imageData.setImageType(imageType);
        imageData.setBase64Str(imData);
        //获取请求访问的唯一标识
        String id = CommonTools.getUUID();
        //获取识别软件就绪状态
        JSONObject statusObject = ImageUtil.getStatus(id);
        String status = statusObject.getString("status");
        if(status.equals("正常")){
            return  ImageUtil.getImageText(id,imageData);
        } else if(status.equals("未就绪")){
            throw new RuntimeException("识别软件未就绪！");
        } else {
            throw new RuntimeException("网络异常:"+statusObject.getString("message"));
        }
    }
}

