SELECT
	*
FROM
	(
	SELECT
		ui.f_userinfo_code,
		uf.f_meter_classify,
		s.f_userinfo_id,
		s.id sell_id,
		case when (num =0 or num is null) then '否' else '是' end f_whether_hand,
		s.f_user_name,
		s.f_meternumber,
		s.f_balance,
		s.f_curbalance,
		s.f_operatorid,
		s.f_operator,
		s.f_orgid,
		s.f_orgname,
		s.f_depid,
		s.f_depname,
		s.f_delaypay,
		s.f_comments,
		isnull( h.f_last_tablebase, 0 ) f_last_tablebase,
		isnull( h.f_tablebase, 0 ) f_tablebase,
		s.f_collection,
		s.f_operate_date operate_date,
		convert(VARCHAR(100),s.f_operate_date,23) f_operate_date,
		isnull( sh.f_sum_debt_money, 0 ) f_sum_debt_money,
		isnull( sh.f_sum_overdue, 0 ) f_sum_overdue,
		isnull( f_sum_oughtamount, 0 ) f_sum_oughtamount,
		isnull( f_sum_oughtfee, 0 ) f_sum_oughtfee
	FROM
		t_sellinggas s
		LEFT JOIN ( SELECT f_sell_id, count(*) num,SUM ( f_debt_money ) f_sum_debt_money, SUM ( f_overdue ) f_sum_overdue FROM t_sellinghand sh WHERE f_state = '有效' and f_type='缴费清欠' GROUP BY f_userfiles_id, f_sell_id ) sh ON s.id= sh.f_sell_id
		LEFT JOIN ( SELECT f_sell_id, min(f_last_tablebase) f_last_tablebase,max(f_tablebase) f_tablebase,SUM ( f_oughtamount ) f_sum_oughtamount, SUM ( f_oughtfee ) f_sum_oughtfee FROM t_handplan WHERE f_hand_state = '有效'  GROUP BY f_userfiles_id, f_sell_id ) h ON s.id= h.f_sell_id
		LEFT JOIN t_userinfo ui ON s.f_userinfo_id= ui.f_userinfo_id
		LEFT JOIN t_userfiles uf ON s.f_userfiles_id= uf.f_userfiles_id
	WHERE
		(s.f_meter_type = '机表'
		OR s.f_meter_type = '卡表')
		AND s.f_state = '有效'
	) t
WHERE
	{condition}
