package com.aote.plugins;

import com.af.plugins.JsonTools;
import com.aote.ThreadResource;
import com.aote.logic.LogicServer;
import com.aote.workflow.plugin.WorkFlowLogicServer;
import org.json.JSONObject;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkFlowTools {
    @Autowired
    private LogicServer logicServer;
    /*
     *  ---WARNING---
     *  workFlow作为业务模块之一
     *  不应有相关插件在公共plugins4.0项目
     *  这导致了workflow包作为不合理的依赖要被引入
     */
    private static final WorkFlowLogicServer workFlowLogicServer = new WorkFlowLogicServer();

    /**
     * 传入测试的json文件路径，进行自动测试
     * 文件格式: {first:{name: 开始业务名, params:{业务逻辑参数}}, next:[{name: 业务逻辑名, params:{业务逻辑参数}}]}
     *
     * @param filePath 测试的json文件路径
     */
    public void runWork(String filePath) throws Exception {
        JSONObject jsonObject = JsonTools.readJsonFile(filePath);
        ThreadResource.ComponentDir.set(jsonObject.get("organization").toString());
        String id = workFlowLogicServer.startWorkflow(jsonObject.getString("workflow_xmlfilename"));
        // 循环执行其他业务逻辑
        for (Object next : jsonObject.getJSONArray("workflow")) {
            runOneLogic((JSONObject) next, new JSONObject("{f_process_id:" + id + "}"));
            // 断言是否为预期流程环节
            String str = workFlowLogicServer.getWait(id);
            Assert.assertEquals(((JSONObject) next).getString("assert"), str);
        }
    }

    // 根据json，执行一条业务逻辑
    // addParam: 附加参数
    public String runOneLogic(JSONObject json, JSONObject addParam) throws Exception {
        JSONObject param = json.getJSONObject("param");
        JsonTools.addJSON(param, addParam);
        return logicServer.run(json.getString("name"), param.toString()).toString();
    }
}
