package com.af.plugins.string;

import net.sf.json.JSON;
import net.sf.json.JSONSerializer;
import net.sf.json.xml.XMLSerializer;
import org.json.JSONObject;

public class XmlUtil {

    /**
     * 将传入的xml参数转为对应的json，包在data中
     * @param xml
     * @return
     */
    public JSONObject xml2Json(String xml) {
        XMLSerializer xmlSerializer = new XMLSerializer();
        JSON read = xmlSerializer.read(xml);
        JSONObject res = new JSONObject();
        res.put("data",read);
        return new JSONObject(res.toString());
    }

    /**
     * json 转换成xml
     * @param json
     * @return
     */
    public String Json2xml(String json,String rootName){
        try {
            XMLSerializer serializer = new XMLSerializer();
            serializer.setRootName(rootName);
            serializer.setTypeHintsEnabled(false);
            JSON jsonObject = JSONSerializer.toJSON(json);
            String result = serializer.write(jsonObject);
            return result;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

}
