package com.af.plugins.timeoutReturn;

import com.aote.util.ResourceHelper;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Component;
import redis.clients.jedis.*;

import java.util.ArrayList;
import java.util.List;

@Component
public class RedisCacheTools {
    private static Logger log = Logger.getLogger(RedisCacheTools.class);
    private static JedisPool jedisPool;
    private static JedisPoolConfig config = new JedisPoolConfig();

    public RedisCacheTools() {
    }

    public void getJedisPool(String host, int port) {
        jedisPool = new JedisPool(config, host, port);
    }

    public Jedis getJedis() {
        return jedisPool.getResource();
    }

    public String getValue(String key) {
        Jedis jedis = getJedis();
        String valString = jedis.get(key);
        jedis.close();
        return valString;
    }

    public  String setValue(String key, String value,int timeout) {
        if(timeout<=0){
            timeout = 30*60;
        }
        Jedis jedis = getJedis();
        String valString = jedis.setex(key, timeout,value.toString());
        jedis.close();
        return valString;
    }

    public  String setValue(String key, String value) {
        Jedis jedis = getJedis();
        String valString = jedis.setex(key, 30*60,value.toString());
        jedis.close();
        return valString;
    }


    public  String removeKey(String key) {
        Jedis jedis = getJedis();
        Long valString = jedis.del(key);
        jedis.close();
        return valString.toString();
    }

    static {
        config.setMaxTotal(200);
        config.setMaxIdle(200);
        config.setMaxWaitMillis(10000L);
        config.setTestOnBorrow(false);
        try{
            String strConfig = ResourceHelper.getString("config.json");
            JSONObject jsonObject = new JSONObject(strConfig);
            if (!jsonObject.has("logicRegister")) {
                jedisPool = new JedisPool(config, "127.0.0.1", 6379);
            }else{
                JSONObject logicJsonObject = jsonObject.getJSONObject("logicRegister");
                String url = logicJsonObject.getString("url");
                JSONObject redisObject = logicJsonObject.getJSONObject("redis");
                String redisHost = redisObject.getString("host");
                int redisPort = redisObject.getInt("port");

                jedisPool = new JedisPool(config, redisHost, redisPort);
            }
        }catch (Exception e ){
            log.debug("获取config.json redis配置失败！！");
        }
    }

}
