package com.af.plugins.likunlong;


import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Scanner;

import javax.imageio.ImageIO;

import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PDF2png {

    //可自由确定起始页和终止页
    public static String pdf2png(String fileAddress, String filename, int indexOfStart, int indexOfEnd) {
        // 将pdf装图片 并且自定义图片得格式大小
        File file = new File(fileAddress + "\\" + filename + ".pdf");
        if (new File(fileAddress + "\\" + filename + "_" + (1) + ".png").exists()) {
            System.out.println("已存在png文件，请重新检查");
            return "已存在png文件，请重新检查";
        } else {

            try {
                PDDocument doc = PDDocument.load(file);
                PDFRenderer renderer = new PDFRenderer(doc);
                int pageCount = doc.getNumberOfPages();
                for (int i = indexOfStart; i < indexOfEnd; i++) {
                    BufferedImage image = renderer.renderImageWithDPI(i, 144); // Windows native DPI
                    // BufferedImage srcImage = resize(image, 240, 240);//产生缩略图
                    ImageIO.write(image, "PNG", new File(fileAddress + "\\" + filename + "_" + (i + 1) + ".png"));
                }
            } catch (IOException e) {
                e.printStackTrace();
                return "转换png时，函数错误";
            }
            return "png转换结束";
        }

    }

    //转换全部的pdf
    public static String pdf2png(String fileAddress, String filename) {
        System.out.println(fileAddress + "---------" + filename);
        // 将pdf装图片 并且自定义图片得格式大小
        File file = new File(fileAddress + "\\" + filename + ".pdf");
        if (new File(fileAddress + "\\" + filename + "_" + (1) + ".png").exists()) {
            System.out.println("已存在png文件，请重新检查");
            return "已存在png文件，请重新检查";
        } else {
            try {
                PDDocument doc = PDDocument.load(file);
                PDFRenderer renderer = new PDFRenderer(doc);
                int pageCount = doc.getNumberOfPages();
                for (int i = 0; i < pageCount; i++) {
                    BufferedImage image = renderer.renderImageWithDPI(i, 144); // Windows native DPI
                    // BufferedImage srcImage = resize(image, 240, 240);//产生缩略图
                    ImageIO.write(image, "PNG", new File(fileAddress + "\\" + filename + "_" + (i + 1) + ".png"));
                }
            } catch (IOException e) {
                e.printStackTrace();
                return "转换png时，函数错误";
            }

            return "转换成功";
        }

    }



}